/* adjustable parameters: (affect only storage requirements of world) */

word
    NAMEMAX = 750,		/* size of name buffer */
    OCCUPANTCOUNT = 6,		/* number of different occupants/territory */

    PATTERNMAX = 40,		/* max # of patterns in world */
    GRIDSPECIALMAX = 100,	/* max # of special patterns in world */
    GRIDMAX = 13,		/* max # of grids in world */
    PICTUREMAX = 30,		/* max # of pictures in world */
    MAZEMAX = 50,		/* max # of mazes in world */
    BITPOSMAX = 4900,		/* max size of all grids/mazes in world */
    LINEMAX = 625,		/* max # of picture line segments */
    OBJECTMAX = 50,		/* max # of object types in world */
    MONSTERMAX = 125,		/* max # of monster types in world */
    TERRITORYMAX = 32;		/* max # of terrain types in world */

/* hardware specifics: */

byte
    SPECTRUMPORT = 0x60,		/* port # for Spectrum board */
    GRAPHICSMODE = 0x2e,		/* value to set graphics mode */
    GRAPHICSOFF = 0x00,			/* value to disable graphics */

    GREEN = 0,
    YELLOW = 1,
    BLUE = 2,
    RED = 3;

/* specifics of how the program uses the hardware: */

word
    PIXELSPERBYTE = 4,			/* # pixels in each screen byte */
    PIXELMASK = 0xff >> (8 - 8 / PIXELSPERBYTE),    /* mask for one pixel */

    SCREENLINES = 192,			/* # lines on graphics screen */
    SCREENCOLS = 128,			/* # cols on graphics screen */
    SCREENMLINES = SCREENLINES,
    SCREENMCOLS = SCREENCOLS / PIXELSPERBYTE, /* # bytes per graphics line */

    DISPLAYLINES = 8,		/* # of lines of patterns on screen */
    DISPLAYCOLS = 8,		/* # of cols of patterns on screen */

    TERRAINBITS = 3,		/* # bits in grid to indicate pattern */
    MAZEBITS = 6,		/* # bits for maze at each position */

    PATTERNLINES = 16,
    PATTERNCOLS = 16,
    PATTERNMLINES = PATTERNLINES,
    PATTERNMCOLS = PATTERNCOLS / PIXELSPERBYTE,/* # bytes per pattern line */

    PICTURELINES = SCREENLINES - 20,		/* # lines in picture area */
    PICTURECOLS =				/* # cols in picture area */
	PICTURELINES * 2 / 3 / (PIXELSPERBYTE * 2) * (PIXELSPERBYTE * 2),
    PICTUREMLINES = PICTURELINES,
    PICTUREMCOLS = PICTURECOLS / PIXELSPERBYTE,

    MAXVIEW = 3,		/* max # maze spaces visible on screen */

    MAZEVSIZE = 22,		/* size of maze position vertically */
    MAZEHSIZE = 15;		/* size of maze position horizontally */

type
    ATTACK = enum {
	A_HARMLESS,
	A_PUNCTURE,
	A_SMASH,
	A_MISSILE,
	A_HEAT,
	A_CHILL,
	A_DISPELL
    },

    MAZEPOSITION = enum {
	M_EMPTY,
	M_LADDER_UP,
	M_LADDER_DOWN,
	M_SPECIAL
    },

    MAZEWALL = enum {
	W_WALL,
	W_EMPTY,
	W_DOOR,
	W_SPECIAL
    },

    SCREENLINE = unsigned SCREENLINES - 1,
    SCREENCOL = unsigned SCREENCOLS - 1,
    SCREENMLINE = unsigned SCREENMLINES - 1,
    SCREENMCOL = unsigned SCREENMCOLS - 1,

    PATTERNLINE = unsigned PATTERNLINES - 1,
    PATTERNCOL = unsigned PATTERNCOLS - 1,
    PATTERNMLINE = unsigned PATTERNMLINES - 1,
    PATTERNMCOL = unsigned PATTERNMCOLS - 1,

    DISPLAYLINE = unsigned DISPLAYLINES - 1,
    DISPLAYCOL = unsigned DISPLAYCOLS - 1,

    GRIDLINE = unsigned 255,
    GRIDCOL = unsigned 255,

    MAZELINE = unsigned 255,
    MAZECOL = unsigned 255,

    GRID = unsigned GRIDMAX,
    MAZE = unsigned MAZEMAX,
    PATTERN = unsigned PATTERNMAX,
    PICTURE = unsigned PICTUREMAX,
    LINE = unsigned LINEMAX,
    GRIDSPECIAL = unsigned GRIDSPECIALMAX,
    BITPOS = unsigned BITPOSMAX,
    OBJECT = unsigned OBJECTMAX,
    MONSTER = unsigned MONSTERMAX,
    TERRITORY = unsigned TERRITORYMAX,

    TERRAIN = unsigned 1 << TERRAINBITS - 1,

/* structure of a 16 x 16 pattern for use on the screen: */

    PATTERNTYPE = [PATTERNMLINES, PATTERNMCOLS] byte,

/* structure of a mazewalk picture of a monster: */

    PICTURETYPE = struct {
	ushort p_lineCount;
	LINE p_start;
    },

/* structure of a line segment for a picture: */

    LINETYPE = struct {
	bool l_symmetric;
	SCREENLINE l_line1;
	SCREENCOL l_col1;
	SCREENLINE l_line2;
	SCREENCOL l_col2;
    },

/* structure of an object type: */

    OBJECTTYPE = struct {
	word ob_name;
	ATTACK ob_type;
	ushort ob_strength;
	ushort ob_weight;
	ushort ob_weakness;
    },

/* structure of a monster type: */

    MONSTERTYPE = struct {
	word m_name;
	PATTERN m_pattern;
	PICTURE m_picture;
	ushort m_strength;
	ushort m_hitPoints;
	ushort m_speed;
	ATTACK m_type;
	[range(ATTACK) - 1] short m_vulnerability;
    },

/* structure of an occupant monster type: */

    OCCUPANTTYPE = struct {
	MONSTER oc_type;
	ushort oc_probability;
    },

/* structure of a territory type: */

    TERRITORYTYPE = struct {
	PATTERN t_pattern;
	[OCCUPANTCOUNT] OCCUPANTTYPE t_occupants;
    },

/* structure of a special display element: */

    GRIDSPECIALTYPE = struct {
	GRID gsp_grid;
	GRIDLINE gsp_line;
	GRIDCOL gsp_col;
	TERRITORY gsp_territory;
    },

/* structure of a grid: */

    GRIDTYPE = struct {
	GRIDLINE g_lines;
	GRIDCOL g_cols;
	[range(TERRAIN)] TERRITORY g_territorys;
	BITPOS g_start;
    },

/* structure of a maze: */

    MAZETYPE = struct {
	MAZELINE ma_lines;
	MAZECOL ma_cols;
	BITPOS ma_start;
	[OCCUPANTCOUNT] OCCUPANTTYPE ma_occupants;
    };

TERRAIN T_SPECIAL = range(TERRAIN);

[SCREENMLINES, SCREENMCOLS] byte Screen @ 0xe000;
