int
    BUFFLEN = 128;
char
    CPM_EOF = '\(0x1a)';
byte
    CPM_FILE_ERROR = 0xff;

type
    FILE = private BUFFLEN + 38,

    F_RETURN = enum {
	F_OK,
	F_BADPAR,
	F_NONEXIS
    },
    
    C_RETURN = enum {
	C_OK,
	C_MISSING,
	C_BADCHAR,
	C_OVERFLOW
    },

    COMPARISON = enum {
	EQUAL,
	LESS,
	GREATER
    };
    
byte
    F_READ = 0x01,
    F_WRITE = 0x02,
    F_CHAR = 0x04,
    F_BINARY = 0x08;

extern

    /* general utilities */

    CharsLen(*char charsPtr)word,
    CharsEqual(*char charsPtr1, charsPtr2)bool,
    CharsCopy(*char dest, source)void,
    CharsCmp(*char charsPtr1, charsPtr2)COMPARISON,
    CharsConcat(*char dest, source)void,
    CharsCopyN(*char dest, source; word n)void,
    CharsIndex(*char subject, object)int,
    exit(int status)void,
    malloc(word length)*byte,
    mfree(*byte pointer; word length)void,

    /* console output routines */

    PChar(char c)void,
    PChars(*char charsPtr)void,
    PInt(int n)void,
    PHex(word n)void,
    PByte(byte b)void,
    PFName(FILE f)void,
    PNL()void,
    PFInt(int n; short length)void,

    /* buffered console typed input routines */

    GInt(*C_RETURN errorPtr)int,
    GHex(*C_RETURN errorPtr)word,
    GChars(*char bufferPtr; char delimiter)void,

    /* string input routines. Work for decoding command parameters */

    GCInt(*char charsPtr; *C_RETURN errorPtr)int,
    GCHex(*char charsPtr; *C_RETURN errorPtr)word,
    GCChars(*char charsPtr, bufferPtr; char delimiter)void,

    /* general output routines */

    PutInt(proc(char c)void putChar; int n)void,
    PutHex(proc(char c)void putChar; word n)void,
    PutByte(proc(char c)void putChar; byte n)void,
    PutChars(proc(char c)void putChar; *char charsPtr)void,
    PutFormatInt(proc(char c)void putChar; int n; short length)void,

    /* general input routines */

    FindNewLine(proc()char getChar; *char charPtr)void,
    SkipNewLine(proc()char getChar; *char charPtr)void,
    GetInt(proc()char getChar; *char charPtr; *C_RETURN errorPtr)int,
    GetHex(proc()char getChar; *char charPtr; *C_RETURN errorPtr)word,
    SkipDelim(proc()char getChar; *char charPtr)void,
    GetChars(proc()char getChar; *char charPtr, bufferPtr; char delim)void,

    /* file name manipulation routines */

    SetFileName(FILE f; *char name)void,
    PutFileName(proc(char c)void putChar; FILE f)void,
    GetFileBase(FILE f; [8] char base)void,
    SetFileBase(FILE f; [8] char base)void,
    GetFileType(FILE f; [3] char typ)void,
    SetFileType(FILE f; [3] char typ)void,

    /* raw buffered console input routines */

    GetLine()void,
    GetChar()char,
    GetCharLine()char,

    /* file I/O routines */

    F_Open(FILE f; *char name; byte flags)F_RETURN,
    F_Open2(FILE f; byte flags)F_RETURN,
    F_Eof(FILE f)bool,
    F_Error(FILE f)bool,
    F_GetChar(FILE f)char,
    F_PutChar(FILE f; char c)void,
    F_Read(FILE f; *char bufferPtr; word count)word,
    F_Write(FILE f; *char bufferPtr; word count)word,
    F_Close(FILE f)void,

    /* command line parameters routines */

    GetPar()*char,
    RescanPars()void;
