/* USER.G - include file for game-writer interface to EXPLORE. */

word
    MAXCARRY = 25,
    DROPPEDMAX = 50,
    NP = 15;			/* number of proc fields in FT */

type
    DROPPED = struct {
	bool d_onGrid;
	ushort d_gridMaze;
	ushort d_line, d_col;
	OBJECT d_object;
    },

    HEADING = enum {NORTH, EAST, SOUTH, WEST},

    FT = struct {

	proc()void Run;
	proc()void Stats;

	proc(GRIDLINE line; GRIDCOL col; TERRITORY t)bool GridNorm;
	proc(GRIDLINE line; GRIDCOL col; TERRITORY t)bool GridSpec;
	proc()void GridMoved;

	proc(MAZELINE line; MAZECOL col)bool MazeMove;
	proc()void MazeUp;
	proc()void MazeDown;
	proc()void MazeMoved;
	proc()void MazeSpec;
	proc(MAZELINE line; MAZECOL col; bool isHor)bool MazeSpecDoor;

	proc()void MonsterCheck;
	proc()void KillMonster;

	proc(OBJECT o)bool Dropped;
	proc(OBJECT o)void Use;

	/* special variables used for intercommunication: */

	bool gameOver;

	bool onGrid;
	GRID grid;
	MAZE maze;
	ushort maxView;
	PATTERN cursorPattern;
	HEADING heading;
	TERRITORY gridTerritory;

	GRIDLINE
	    gridLines,
	    windowLineTop,
	    gridLine;
	GRIDCOL
	    gridCols,
	    windowColLeft,
	    gridCol;
	MAZELINE
	    mazeLines,
	    mazeLine;
	MAZECOL
	    mazeCols,
	    mazeCol;

	word hitPoints, strength, experience, money, food, health;
	[range(ATTACK) - 1] word protection;

	word maxCarryWeight;
	ushort maxCarryCount;
	word carryWeight;
	ushort carryCount;
	[MAXCARRY] OBJECT carrying;

	ushort droppedCount;
	[DROPPEDMAX] DROPPED droppedList;

	bool armed;
	OBJECT weaponNumber;

	bool underAttack;
	MONSTER monsterNumber;
	MONSTERTYPE monsterData;

	word rate;
	ushort beepLevel;
	bool printing;
    };

FT f @ 0x6b00;		/* 'f' is used because its easy to type */
