#drinc:utility/tagitem.g
#drinc:exec/memory.g
#drinc:exec/ports.g
#drinc:exec/tasks.g
#drinc:exec/io.g
#drinc:graphics/gfx.g
#drinc:graphics/gfxBase.g
#drinc:graphics/view.g
#drinc:graphics/clip.g
#drinc:graphics/layers.g
#drinc:graphics/rastport.g
#drinc:graphics/text.g
#drinc:devices/timer.g
#drinc:devices/inputevent.g
#drinc:devices/console.g
#drinc:devices/conunit.g
#drinc:intuition/miscellaneous.g
#drinc:intuition/new_screen.g
#drinc:intuition/window.g
#drinc:intuition/intuiText.g
#drinc:intuition/image.g
#drinc:intuition/menu.g
#drinc:intuition/gadget.g
#drinc:intuition/requester.g
#drinc:intuition/border.g
#drinc:intuition/intuiMessage.g
#drinc:libraries/dos.g
#drinc:libraries/asl.g
#drinc:util.g

#/Include/MUD.g
#/Include/Effects.g
#graphics.g
#text.g
#globals.g
#funcs.g

/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * intuition.d - amiga intuition specific stuff.
 */

uint
    LORES_SCREEN_SEP = 3,
    HIRES_SCREEN_SEP = 6,
    WORKBENCH_SEP = 3,
    LORES_DELTA = LORES_GRAPHICS_HEIGHT + LORES_SCREEN_SEP,
    HIRES_DELTA = HIRES_GRAPHICS_HEIGHT + HIRES_SCREEN_SEP,

    OLD_BORDER = 4,
    OLD_TOP_BORDER = TITLE_BAR + OLD_BORDER,
    OLD_SIDE_BORDER = OLD_BORDER * 2,
    OLD_BOTTOM_BORDER = OLD_BORDER,

    NEW_TOP_BORDER = TITLE_BAR,
    NEW_LEFT_BORDER = 4,
    NEW_RIGHT_BORDER = NEW_SCROLL_WIDTH,
    NEW_BOTTOM_BORDER = 2,

    DIR_MAX = 150,
    FILE_NAME_MAX = 69,
    REQUEST_MAX = 80,

    STRING_REQ_WIDTH = FILE_NAME_MAX * CHAR_WIDTH + 20,
    STRING_REQ_HEIGHT = CHAR_HEIGHT * 3 + 8,

    RAW_MAX = 100,

    SOURCE_MAX = 512,

    STRING_GADGET_ID = 0,
    CANCEL_GADGET_ID = 1;

type FileType_t = enum {
    ft_source,
    ft_snap,
    ft_log
};

/* variables */

AreaInfo_t GraphicsAreaInfo;
[AREA_SIZE] uint GraphicsAreaBuf;
PLANEPTR GraphicsTempPlane;
TmpRas_t GraphicsTmpRas;
*ViewPort_t TextViewPort;
*Screen_t TextScreen, GraphicsScreen;
*Window_t GraphicsWindow;
*Menu_t MainMenu;
*FileRequester_t AslReq;
*TextFont_t MyFont;
uint DisplayRows, FullDisplayRows, DisplayCols, GraphicsRightBorder;

ulong SourceFd;
[SOURCE_MAX] char SourceBuffer;

bool GraphicsOn, SoundOn, MusicOn, VoiceOn, WorkBenchOn, Logging, Scrolling,
    HadRAB, UsingSerial, EditToggle, SkipRefresh, AslActive;

IOStdReq_t IoStd;
[128] uint KeyMapTable;
[RAW_MAX] char RawBuffer;		/* raw from keyboard */

[FILE_NAME_MAX] char LogFileName;
[FILE_NAME_MAX] char SourceFileName;
[FILE_NAME_MAX] char SnapFileName;
[DIR_MAX] char LogDir;
[DIR_MAX] char SourceDir;
[DIR_MAX] char SnapDir;
[REQUEST_MAX + 1] char RequestString, StringUndo;

/* static colour maps */

[1 << TEXT_DEPTH] uint DimTextColourTable := (
    0x000, 0xa60, 0x850, 0xb80
);

[1 << TEXT_DEPTH] uint RegularTextColourTable := (
    0x000, 0xb80, 0xa60, 0xda0
);

[1 << TEXT_DEPTH] uint BrightTextColourTable := (
    0x000, 0xda0, 0xb80, 0xfc0
);

[GRAPHICS_COLOURS] uint GraphicsColourTable := (
    0x000,	/* 00 - black */
    0x777,	/* 01 - dark grey */
    0x999,	/* 02 - medium grey */
    0xccc,	/* 03 - light grey */
    0xfff,	/* 04 - white */
    0xd00,	/* 05 - brick red */
    0xf00,	/* 06 - red */
    0xf80,	/* 07 - red-orange */
    0xf90,	/* 08 - orange */
    0xfc0,	/* 09 - gold */
    0xfd0,	/* 10 - cadmium yellow */
    0xff0,	/* 11 - lemon yellow */
    0xbf0,	/* 12 - lime green */
    0x0f0,	/* 13 - green */
    0x8e0,	/* 14 - light green */
    0x2c0,	/* 15 - dark green */
    0x0b1,	/* 16 - forest green */
    0x0bb,	/* 17 - blue green */
    0x0db,	/* 18 - aqua */
    0x1fb,	/* 19 - light aqua */
    0x6fe,	/* 20 - sky blue */
    0x6ce,	/* 21 - light blue */
    0x00f,	/* 22 - blue */
    0x69f,	/* 23 - dark blue */
    0xc1f,	/* 24 - violet */
    0xc0e,	/* 25 - purple */
    0xf99,	/* 26 - flesh */
    0xfad,	/* 27 - pink */
    0xdb9,	/* 28 - tan */
    0xc80,	/* 29 - brown */
    0xa70,	/* 30 - medium brown */
    0xa87	/* 31 - dark brown */
);

/* static structures for menus */

uint MY_CHECKWIDTH = (CHECKWIDTH + (8 - 1)) / 8 * 8;

[2] IntuiText_t OnOff := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "On", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Off", nil)
);

/* The "Project" menu structure. */

uint
    PROJECT_MENU_WIDTH =
	if 10 * 8 > 4 * 8 + COMMWIDTH + 16 then
	    10 * 8
	else
	    4 * 8 + COMMWIDTH + 16
	fi + 2,
    PROJECT_SUB_COL = PROJECT_MENU_WIDTH - 8 * 2,
    LOG_MENU_WIDTH = 5 * 8 + 2 + CHECKWIDTH;

[2] IntuiText_t LogModeTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Both", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Input", nil)
);

[2] MenuItem_t LogModeItem := (
    (&LogModeItem[1], PROJECT_SUB_COL, 0 * 9, LOG_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x2, (&LogModeTexts[0]), (nil), ' ', nil, 0),
    (nil,	      PROJECT_SUB_COL, 1 * 9, LOG_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x1, (&LogModeTexts[1]), (nil), ' ', nil, 0)
);

[2] IntuiText_t SnapshotTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Text", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Graphics", nil)
);

[2] MenuItem_t SnapshotItem := (
    (&SnapshotItem[1], PROJECT_SUB_COL, 0 * 9, 8 * 8 + 2, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x2, (&SnapshotTexts[0]), (nil), ' ', nil, 0),
    (nil,	       PROJECT_SUB_COL, 1 * 9, 8 * 8 + 2, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x1, (&SnapshotTexts[1]), (nil), ' ', nil, 0)
);

[7] IntuiText_t ProjectTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Log  F7", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Log File", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Log Mode \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Source", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Snapshot \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Quit ", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Abort", nil)
);

[7] MenuItem_t ProjectItems := (
    (&ProjectItems[1], 0, 0 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x0, (&ProjectTexts[0]), (nil), ' ', nil, 0),
    (&ProjectItems[2], 0, 1 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ProjectTexts[1]), (nil), ' ', nil, 0),
    (&ProjectItems[3], 0, 2 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ProjectTexts[2]), (nil), ' ', &LogModeItem[0], 0),
    (&ProjectItems[4], 0, 3 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | HIGHCOMP,
     0x0, (&ProjectTexts[3]), (nil), ' ', nil, 0),
    (&ProjectItems[5], 0, 4 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ProjectTexts[4]), (nil), ' ', &SnapshotItem[0], 0),
    (&ProjectItems[6], 0, 5 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&ProjectTexts[5]), (nil), 'Q', nil, 0),
    (nil,	       0, 6 * 9, PROJECT_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ProjectTexts[6]), (nil), ' ', nil, 0)
);

/* The "Modes" menu structure. */

uint
    MODES_MENU_WIDTH = 15 * 8 + 2,
    MODES_SUB_COL = MODES_MENU_WIDTH - 8 * 2,
    HISTORY_MENU_WIDTH = 7 * 8 + 2 + CHECKWIDTH;

[3] IntuiText_t HistoryText := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Full",    nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "New",     nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Minimal", nil)
);

[3] MenuItem_t HistoryItem := (
    (&HistoryItem[1], MODES_SUB_COL, 0 * 9, HISTORY_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x6, (&HistoryText[0]), (nil), ' ', nil, 0),
    (&HistoryItem[2], MODES_SUB_COL, 1 * 9, HISTORY_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x5, (&HistoryText[1]), (nil), ' ', nil, 0),
    (nil,	      MODES_SUB_COL, 2 * 9, HISTORY_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x3, (&HistoryText[2]), (nil), ' ', nil, 0)
);

[4] IntuiText_t ScrollText := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Input  ", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Output ", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Either ", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Neither", nil)
);

uint SCROLL_MENU_WIDTH = 7 * 8 + 2 + CHECKWIDTH;

[4] MenuItem_t ScrollItem := (
    (&ScrollItem[1], MODES_SUB_COL, 0 * 9, SCROLL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0xe, (&ScrollText[0]), (nil), ' ', nil, 0),
    (&ScrollItem[2], MODES_SUB_COL, 1 * 9, SCROLL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0xd, (&ScrollText[1]), (nil), ' ', nil, 0),
    (&ScrollItem[3], MODES_SUB_COL, 2 * 9, SCROLL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0xb, (&ScrollText[2]), (nil), ' ', nil, 0),
    (nil,	     MODES_SUB_COL, 3 * 9, SCROLL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x7, (&ScrollText[3]), (nil), ' ', nil, 0)
);

[3] IntuiText_t EditorText := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Internal", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Selected", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "External", nil)
);

uint EDITOR_MENU_WIDTH = 8 * 8 + 2 + CHECKWIDTH;

[3] MenuItem_t EditorItem := (
    (&EditorItem[1], MODES_SUB_COL, 0 * 9, EDITOR_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0xe, (&EditorText[0]), (nil), ' ', nil, 0),
    (&EditorItem[2], MODES_SUB_COL, 1 * 9, EDITOR_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0xd, (&EditorText[1]), (nil), ' ', nil, 0),
    (nil,	     MODES_SUB_COL, 2 * 9, EDITOR_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0xb, (&EditorText[2]), (nil), ' ', nil, 0)
);

[9] IntuiText_t ModesTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "History       \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Scroll On     \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0, 1, nil, "Editor        \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Picture   F1", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Graphics  F2", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Sound     F3", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Music     F4", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Voice     F5", nil),
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "Edit Win  F6", nil)
);

[9] MenuItem_t ModesItems := (
    (&ModesItems[1], 0, 0 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ModesTexts[0]), (nil), ' ', &HistoryItem[0], 0),
    (&ModesItems[2], 0, 1 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ModesTexts[1]), (nil), ' ', &ScrollItem[0], 0),
    (&ModesItems[3], 0, 2 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&ModesTexts[2]), (nil), ' ', &EditorItem[0], 0),
    (&ModesItems[4], 0, 3 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&ModesTexts[3]), (nil), ' ', nil, 0),
    (&ModesItems[5], 0, 4 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&ModesTexts[4]), (nil), ' ', nil, 0),
    (&ModesItems[6], 0, 5 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&ModesTexts[5]), (nil), ' ', nil, 0),
    (&ModesItems[7], 0, 6 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&ModesTexts[6]), (nil), ' ', nil, 0),
    (&ModesItems[8], 0, 7 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&ModesTexts[7]), (nil), ' ', nil, 0),
    (nil	   , 0, 8 * 9, MODES_MENU_WIDTH, 9,
     ITEMTEXT | HIGHCOMP | CHECKIT,
     0x0, (&ModesTexts[8]), (nil), ' ', nil, 0)
);

/* The "Options" menu structure. */

uint
    OPTIONS_MENU_WIDTH = 12 * 8 + 2 + COMMWIDTH + 16,
    OPTIONS_SUB_COL = OPTIONS_MENU_WIDTH - 8 * 3,
    EFFECTS_MENU_WIDTH = 11 * 8 + 2 + COMMWIDTH + 16;

[5] IntuiText_t EffectsTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, 0	  , 1, nil, "Free File"  , nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	  , 1, nil, "Free Effect", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	  , 1, nil, "Zap Effects", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	  , 1, nil, "Show Caches", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Quiet"	 , nil)
);

[5] MenuItem_t EffectsItem := (
    (&EffectsItem[1], OPTIONS_SUB_COL, 0 * 9, EFFECTS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&EffectsTexts[0]), (nil), ' ', nil, 0),
    (&EffectsItem[2], OPTIONS_SUB_COL, 1 * 9, EFFECTS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&EffectsTexts[1]), (nil), ' ', nil, 0),
    (&EffectsItem[3], OPTIONS_SUB_COL, 2 * 9, EFFECTS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&EffectsTexts[2]), (nil), 'Z', nil, 0),
    (&EffectsItem[4], OPTIONS_SUB_COL, 3 * 9, EFFECTS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&EffectsTexts[3]), (nil), ' ', nil, 0),
    (nil	    , OPTIONS_SUB_COL, 4 * 9, EFFECTS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x0, (&EffectsTexts[4]), (nil), ' ', nil, 0)
);

[4] IntuiText_t OptionsTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, 0,	    1, nil, "ScreenToBack", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "Workbench"   , nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0,     1, nil, "Effects         \(0xbb)", nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0,	    1, nil, "Memory"	  , nil)
);

[4] MenuItem_t OptionsItems := (
    (&OptionsItems[1], 0, 0 * 9, OPTIONS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&OptionsTexts[0]), (nil), 'B', nil, 0),
    (&OptionsItems[2], 0, 1 * 9, OPTIONS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT | CHECKED,
     0x0, (&OptionsTexts[1]), (nil), ' ', nil, 0),
    (&OptionsItems[3], 0, 2 * 9, OPTIONS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&OptionsTexts[2]), (nil), ' ', &EffectsItem[0], 0),
    (nil	     , 0, 3 * 9, OPTIONS_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&OptionsTexts[3]), (nil), ' ', nil, 0)
);

/* The "Serial" menu structure. */

uint
    BAUD_MENU_WIDTH = 6 * 8 + 2 + CHECKWIDTH,
    BAUD_SUB_COL = 9 * 8 + 7,
    SERIAL_MENU_WIDTH =
	if 8 * 8 + 2 + MY_CHECKWIDTH > 7 * 8 + 2 + COMMWIDTH + 16 then
	    8 * 8 + 2 + MY_CHECKWIDTH
	else
	    7 * 8 + 2 + COMMWIDTH + 16
	fi;

[7] IntuiText_t BaudText := (
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "  1200", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "  2400", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "  9600", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, " 19200", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, " 38400", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, " 57600", nil),
    (ERASE_PEN, DARK_PEN, JAM1, CHECKWIDTH, 1, nil, "115200", nil)
);

[7] MenuItem_t BaudItem := (
    (&BaudItem[1], BAUD_SUB_COL, 0 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x1e, (&BaudText[0]), (nil), ' ', nil, 0),
    (&BaudItem[2], BAUD_SUB_COL, 1 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x1d, (&BaudText[1]), (nil), ' ', nil, 0),
    (&BaudItem[3], BAUD_SUB_COL, 2 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x1b, (&BaudText[2]), (nil), ' ', nil, 0),
    (&BaudItem[4], BAUD_SUB_COL, 3 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x17, (&BaudText[3]), (nil), ' ', nil, 0),
    (&BaudItem[5], BAUD_SUB_COL, 4 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x17, (&BaudText[4]), (nil), ' ', nil, 0),
    (&BaudItem[6], BAUD_SUB_COL, 5 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x17, (&BaudText[5]), (nil), ' ', nil, 0),
    (nil,	   BAUD_SUB_COL, 6 * 9, BAUD_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x0f, (&BaudText[6]), (nil), ' ', nil, 0)
);

[5] IntuiText_t SerialTexts := (
    (ERASE_PEN, DARK_PEN, JAM1, MY_CHECKWIDTH, 1, nil, "IgnoreCD"	, nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	 , 1, nil, "Speed      \(0xbb)" , nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	     , 1, nil, "Break"		, nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	     , 1, nil, "Connect"	, nil),
    (ERASE_PEN, DARK_PEN, JAM1, 0	     , 1, nil, "Stats"		, nil)
);

[5] MenuItem_t SerialItems := (
    (&SerialItems[1], 0, 0 * 9, SERIAL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | CHECKIT,
     0x0, (&SerialTexts[0]), (nil), ' ', nil, 0),
    (&SerialItems[2], 0, 1 * 9, SERIAL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP,
     0x0, (&SerialTexts[1]), (nil), ' ', &BaudItem[0], 0),
    (&SerialItems[3], 0, 2 * 9, SERIAL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&SerialTexts[2]), (nil), '.', nil, 0),
    (&SerialItems[4], 0, 3 * 9, SERIAL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&SerialTexts[3]), (nil), 'C', nil, 0),
    (nil,	      0, 4 * 9, SERIAL_MENU_WIDTH, 9,
     ITEMTEXT | ITEMENABLED | HIGHCOMP | COMMSEQ,
     0x0, (&SerialTexts[4]), (nil), 'S', nil, 0)
);

/* The top level menu structure. */

[4] Menu_t Menus := (
    (&Menus[1],  0 * 8, 0, 7 * 8 + 5, 10, MENUENABLED,
     "Project", &ProjectItems[0], 0, 0, 0, 0),
    (&Menus[2],  9 * 8, 0, 5 * 8 + 5, 10, MENUENABLED,
     "Modes"  , &ModesItems[0], 0, 0, 0, 0),
    (&Menus[3], 16 * 8, 0, 7 * 8 + 5, 10, MENUENABLED,
     "Options", &OptionsItems[0], 0, 0, 0, 0),
    (nil,	25 * 8, 0, 6 * 8 + 5, 10, MENUENABLED,
     "Serial" , &SerialItems[0], 0, 0, 0, 0)
);

/* stuff for the string requester for log/source file names */

[5 * 2] int StringCancelBox := (
    0, 0,
    CHAR_WIDTH * 6 + 2 * 2 + 1, 0,
    CHAR_WIDTH * 6 + 2 * 2 + 1, CHAR_HEIGHT + 2 * 2 + 1,
    0, CHAR_HEIGHT + 2 * 2 + 1,
    0, 0
);

Border_t StringCancelBorder := (
    0, 0, STD_TEXT_PEN, DARK_PEN, JAM1, 5, &StringCancelBox[0], nil
);

IntuiText_t StringCancelText := (
    STD_TEXT_PEN, DARK_PEN, JAM1, 3 * 1, 3 * 1, nil, "CANCEL", nil
);

Gadget_t StringCancelGadget := (
    nil,
    STRING_REQ_WIDTH - (CHAR_WIDTH * 6 + 2 * 3) - 6, 4,
    CHAR_WIDTH * 6 + 2 * 3, CHAR_HEIGHT + 2 * 3,
    GADGHCOMP, RELVERIFY | ENDGADGET, BOOLGADGET | REQGADGET,
    (nil), (nil), &StringCancelText, 0x0, (nil), CANCEL_GADGET_ID, nil
);

StringInfo_t StringInfo := (
    nil, nil, 0, 0,
    0, 0, 0, 0, 0, 0, nil, 0, nil
);

Gadget_t StringReqGadget := (
    &StringCancelGadget,
    9, 19, STRING_REQ_WIDTH - 16, CHAR_HEIGHT + 2,
    GADGHCOMP, RELVERIFY | ENDGADGET, STRGADGET | REQGADGET,
    (nil), (nil), nil, 0x0, (nil), STRING_GADGET_ID, nil
);

[5 * 2] int StringReqBox := (
    4, 2,
    STRING_REQ_WIDTH - 5, 2,
    STRING_REQ_WIDTH - 5, STRING_REQ_HEIGHT - 3,
    4, STRING_REQ_HEIGHT - 3,
    4, 2
);

Border_t StringReqBorder := (
    0, 0, STD_TEXT_PEN, DARK_PEN, JAM1, 5, &StringReqBox[0], nil
);

/* stuff for the abort requester */

IntuiText_t AbortBodyText := (
    ERASE_PEN, DARK_PEN, JAM1, 8, 8, nil, "Really Abort?", nil
);

IntuiText_t AbortYesText := (
    ERASE_PEN, DARK_PEN, JAM1, 6, 4, nil, "YES", nil
);

IntuiText_t AbortNoText := (
    ERASE_PEN, DARK_PEN, JAM1, 6, 4, nil, "NO", nil
);

/* describe the standard built-in font if we need to get it */

TextAttr_t StandardFont := (
    "topaz.font", CHAR_HEIGHT, FS_NORMAL, FPF_ROMFONT
);


/*****************************************************************************/

/* Now the code */

/*
 * fixTexts - part of fixMenus.
 */

proc fixTexts(register *IntuiText_t it; register *TextAttr_t desiredAttr;
	      register uint count)void:

    while count ~= 0 do
	if OS3 then
	    it*.it_FrontPen := TextPen;
	    it*.it_BackPen := ErasePen;
	fi;
	it*.it_ITextFont := desiredAttr;
	it := it + sizeof(IntuiText_t);
	count := count - 1;
    od;
corp;

/*
 * fixMenus - on startup, do the menu fixups we need.
 */

proc fixMenus(bool usingSerial; register *TextAttr_t desiredAttr;
	      uint charWidth)void:
    register *IntuiText_t it;
    register *Menu_t m @ it;
    register uint itSize, i @ itSize;

    if usingSerial then
	/* initialize the menu state to reflect any command line or
	   tool name flags given on startup */
	if SerialIgnoreCD then
	    SerialItems[0].mi_Flags := SerialItems[0].mi_Flags | CHECKED;
	fi;
	case SerialBaud
	incase 1200:
	    BaudItem[0].mi_Flags := BaudItem[0].mi_Flags | CHECKED;
	incase 2400:
	    BaudItem[1].mi_Flags := BaudItem[1].mi_Flags | CHECKED;
	incase 9600:
	    BaudItem[2].mi_Flags := BaudItem[2].mi_Flags | CHECKED;
	incase 19200:
	    BaudItem[3].mi_Flags := BaudItem[3].mi_Flags | CHECKED;
	incase 38400:
	    BaudItem[4].mi_Flags := BaudItem[4].mi_Flags | CHECKED;
	incase 57600:
	    BaudItem[5].mi_Flags := BaudItem[5].mi_Flags | CHECKED;
	incase 115200:
	    BaudItem[6].mi_Flags := BaudItem[6].mi_Flags | CHECKED;
	esac;
	/* this just makes the program serially re-usable */
	Menus[2].m_NextMenu := &Menus[3];
    else
	/* do not even show the Serial menu */
	Menus[2].m_NextMenu := nil;
    fi;
    case EditorChoice
    incase ed_internal:
	EditorItem[0].mi_Flags := EditorItem[0].mi_Flags | CHECKED;
    incase ed_selected:
	EditorItem[1].mi_Flags := EditorItem[1].mi_Flags | CHECKED;
    incase ed_external:
	EditorItem[2].mi_Flags := EditorItem[2].mi_Flags | CHECKED;
    esac;
    if EffectsQuiet then
	EffectsItem[4].mi_Flags := EffectsItem[4].mi_Flags | CHECKED;
    fi;
    if Mode = md_oneWindow or Mode = md_twoWindow then
	OptionsItems[0].mi_Flags := OptionsItems[0].mi_Flags & ~ITEMENABLED;
	OptionsItems[1].mi_Flags := OptionsItems[1].mi_Flags & ~ITEMENABLED;
	ModesItems[3].mi_Flags := ModesItems[3].mi_Flags & ~ITEMENABLED;

	fixTexts(&OnOff[0], desiredAttr, 2);
	fixTexts(&LogModeTexts[0], desiredAttr, 2);
	fixTexts(&SnapshotTexts[0], desiredAttr, 2);
	fixTexts(&ProjectTexts[0], desiredAttr, 7);
	fixTexts(&HistoryText[0], desiredAttr, 3);
	fixTexts(&ScrollText[0], desiredAttr, 4);
	fixTexts(&EditorText[0], desiredAttr, 3);
	fixTexts(&ModesTexts[0], desiredAttr, 9);
	fixTexts(&EffectsTexts[0], desiredAttr, 5);
	fixTexts(&OptionsTexts[0], desiredAttr, 4);
	fixTexts(&BaudText[0], desiredAttr, 7);
	fixTexts(&SerialTexts[0], desiredAttr, 5);

	StringCancelText.it_ITextFont := desiredAttr;
	AbortBodyText.it_ITextFont := desiredAttr;
	AbortYesText.it_ITextFont := desiredAttr;
	AbortNoText.it_ITextFont := desiredAttr;

	if charWidth ~= 8 then
	    m := &Menus[0];
	    for i from 3 downto 0 do
		m*.m_LeftEdge := m*.m_LeftEdge / 8 * charWidth;
		m*.m_Width := m*.m_Width / 8 * charWidth;
		m := m + sizeof(Menu_t);
	    od;
	fi;
    fi;
corp;

/*
 * getBaseSizes - get the basic display size of the user's display. This
 *	works on all versions of the OS. This stuff is only relevant when
 *	we have our own screen(s). The DisplayRows and DisplayCols variables
 *	are the size of the (text) window when on Workbench.
 */

proc getBaseSizes()void:
    Screen_t wbSC;

    if GetScreenData(pretend(&wbSC,*byte), sizeof(Screen_t), WBENCHSCREEN, nil)
    then
	DisplayRows := wbSC.sc_Height;
	if DisplayRows >= 400 then
	    DisplayRows := DisplayRows / 2;
	fi;
	DisplayCols := wbSC.sc_Width;
    else
	DisplayRows := GfxBase*.gb_NormalDisplayRows;
	DisplayCols := GfxBase*.gb_NormalDisplayColumns;
    fi;
    if GfxBase*.gb_DisplayFlags & (NTSC | PAL) = NTSC then
	if DisplayRows > 234 then
	    DisplayRows := 234;
	fi;
    elif GfxBase*.gb_DisplayFlags & (NTSC | PAL) = PAL then
	if DisplayRows > 339 then
	    DisplayRows := 339;
	fi;
    fi;
    if DisplayCols > 720 then
	DisplayCols := 720;
    fi;
    if HiRes then
	DisplayRows := DisplayRows * 2;
	if Mode = md_oneScreen then
	    if DisplayRows < HIRES_GRAPHICS_HEIGHT * 2 then
		DisplayRows := HIRES_GRAPHICS_HEIGHT * 2;
	    fi;
	    if DisplayCols < HIRES_GRAPHICS_WIDTH then
		DisplayCols := HIRES_GRAPHICS_WIDTH;
	    fi;
	fi;
    else
	if Mode = md_oneScreen then
	    if DisplayCols < HIRES_GRAPHICS_WIDTH then
		DisplayCols := HIRES_GRAPHICS_WIDTH;
	    fi;
	fi;
    fi;

    if HiRes then
	GraphicsWidth := HIRES_GRAPHICS_WIDTH;
	GraphicsHeight := HIRES_GRAPHICS_HEIGHT;
	if Mode = md_oneScreen then
	    ScreenDelta := HIRES_GRAPHICS_HEIGHT;
	else
	    ScreenDelta := HIRES_DELTA;
	fi;
    else
	if Mode = md_oneScreen then
	    GraphicsWidth := HIRES_GRAPHICS_WIDTH;
	    ScreenDelta := LORES_GRAPHICS_HEIGHT;
	else
	    GraphicsWidth := LORES_GRAPHICS_WIDTH;
	    ScreenDelta := LORES_DELTA;
	fi;
	GraphicsHeight := LORES_GRAPHICS_HEIGHT;
    fi;
corp;

/*
 * setSizes - get info from the public screen, if possible. Return
 *	'false' if we are running on Workbench, but cannot do so. Set up
 *	the border sizes based on the screen info, and if we are running
 *	in one Workbench window, choose the size of that window, and the
 *	size of the graphics display within that window.
 */

proc setSizes()bool:
    *Screen_t sc;
    uint rowSpace, colSpace, rowWant, colWant;
    bool onWorkbench;

    Depth := GRAPHICS_DEPTH;
    ColourCount := GRAPHICS_COLOURS;
    GXOffset := 0;
    GYOffset := 0;
    if OldStyle then
	TopBorder := OLD_TOP_BORDER;
	LeftBorder := OLD_SIDE_BORDER;
	RightBorder := OLD_SCROLL_WIDTH + OLD_SIDE_BORDER;
	BottomBorder := OLD_BORDER;
	ScrollWidth := OLD_SCROLL_WIDTH;
    else
	onWorkbench := Mode = md_oneWindow or Mode = md_twoWindow;
	ScrollWidth :=
	    if onWorkbench then
		WB_SCROLL_WIDTH
	    elif HiRes then
		NEW_SCROLL_WIDTH
	    else
		OLD_SCROLL_WIDTH
	    fi;
	sc := LockPubScreen(nil);
	if sc ~= nil then
	    TopBorder := sc*.sc_WBorTop;
	    if sc*.sc_Font ~= nil then
		TopBorder := TopBorder + sc*.sc_Font*.ta_YSize + 1;
	    else
		TopBorder := TopBorder + (CHAR_HEIGHT + 1);
	    fi;
	    LeftBorder := sc*.sc_WBorLeft;
	    RightBorder := sc*.sc_WBorRight;
	    GraphicsRightBorder := RightBorder;
	    /* Why do we have to kludge it like this? */
	    if onWorkbench then
		if RightBorder < WB_SCROLL_WIDTH + 2 then
		    RightBorder := WB_SCROLL_WIDTH + 2;
		fi;
	    else
		if RightBorder < ScrollWidth + 1 then
		    RightBorder := ScrollWidth + 1;
		fi;
	    fi;
	    BottomBorder := sc*.sc_WBorBottom;

	    if onWorkbench then
		Depth := sc*.sc_BitMap.bm_Depth;
		ColourCount := 1 << Depth;
		if ColourCount > MAX_COLOURS then
		    ColourCount := MAX_COLOURS;
		fi;
		DisplayRows := sc*.sc_Height;
		/* Save a copy so can position hires text window when we
		   are in md_twoWindow mode. */
		FullDisplayRows := DisplayRows;
		DisplayCols := sc*.sc_Width;
		if Mode = md_oneWindow then
		    /* How big should our window be? How big will the graphics
		       display be? */
		    rowSpace :=
			DisplayRows - TopBorder - BottomBorder - WORKBENCH_SEP;
		    colSpace := DisplayCols - LeftBorder - RightBorder;
		    if rowSpace < LORES_GRAPHICS_HEIGHT * 2 + CHAR_HEIGHT * 5
			or colSpace < LORES_GRAPHICS_HEIGHT * 2
		    then
			HiRes := false;
		    fi;
		    if HiRes then
			rowWant := EDIT_HELP_HEIGHT * CHAR_HEIGHT +
			    LORES_GRAPHICS_HEIGHT * 2;
			if rowWant > rowSpace then
			    rowWant := (rowSpace - LORES_GRAPHICS_HEIGHT * 2) /
				CHAR_HEIGHT * CHAR_HEIGHT +
				LORES_GRAPHICS_HEIGHT * 2;
			fi;
			colWant := TEXT_COLUMNS * CHAR_WIDTH;
			if colWant < LORES_GRAPHICS_WIDTH * 2 then
			    colWant := LORES_GRAPHICS_WIDTH * 2;
			fi;
			if colWant > colSpace then
			    colWant := colSpace / CHAR_WIDTH * CHAR_WIDTH;
			    if colWant < LORES_GRAPHICS_WIDTH * 2 then
				colWant := LORES_GRAPHICS_WIDTH * 2;
			    fi;
			fi;
			GraphicsWidth := LORES_GRAPHICS_WIDTH * 2;
			GraphicsHeight := LORES_GRAPHICS_HEIGHT * 2;
		    else
			rowWant := EDIT_HELP_HEIGHT * CHAR_HEIGHT +
			    LORES_GRAPHICS_HEIGHT;
			if rowWant > rowSpace then
			    rowWant := (rowSpace - LORES_GRAPHICS_HEIGHT) /
				CHAR_HEIGHT * CHAR_HEIGHT +
				LORES_GRAPHICS_HEIGHT;
			fi;
			colWant := TEXT_COLUMNS * CHAR_WIDTH;
			if colWant < LORES_GRAPHICS_WIDTH then
			    /* Bloody unlikely! */
			    colWant := LORES_GRAPHICS_WIDTH;
			fi;
			if colWant > colSpace then
			    colWant := colSpace / CHAR_WIDTH * CHAR_WIDTH;
			    if colWant < LORES_GRAPHICS_WIDTH then
				colWant := LORES_GRAPHICS_WIDTH;
			    fi;
			fi;
			GraphicsWidth := LORES_GRAPHICS_WIDTH;
			GraphicsHeight := LORES_GRAPHICS_HEIGHT;
		    fi;
		    ScreenDelta := GraphicsHeight + WORKBENCH_SEP;
		    DisplayRows :=
			rowWant + TopBorder + BottomBorder + WORKBENCH_SEP;
		else
		    rowSpace := DisplayRows - TopBorder - BottomBorder;
		    colSpace := DisplayCols - LeftBorder - RightBorder;
		    /* Decide on the resolution of the graphics area */
		    if rowSpace < LORES_GRAPHICS_HEIGHT * 2 or
			colSpace < LORES_GRAPHICS_HEIGHT * 2
		    then
			HiRes := false;
		    fi;
		    if HiRes then
			GraphicsWidth := LORES_GRAPHICS_WIDTH * 2;
			GraphicsHeight := LORES_GRAPHICS_HEIGHT * 2;
		    else
			GraphicsWidth := LORES_GRAPHICS_WIDTH;
			GraphicsHeight := LORES_GRAPHICS_HEIGHT;
		    fi;
		    rowWant := EDIT_HELP_HEIGHT * CHAR_HEIGHT;
		    if rowWant > rowSpace then
			rowWant := rowSpace / CHAR_HEIGHT * CHAR_HEIGHT;
		    fi;
		    colWant := TEXT_COLUMNS * CHAR_WIDTH;
		    if colWant > colSpace then
			colWant := colSpace / CHAR_WIDTH * CHAR_WIDTH;
		    fi;
		    ScreenDelta := 0;
		    DisplayRows := rowWant + TopBorder + BottomBorder;
		fi;
		DisplayCols := colWant + LeftBorder + RightBorder;
		GXOffset := LeftBorder;
		GYOffset := TopBorder;
	    fi;

	    UnlockPubScreen(nil, sc);
	else
	    if onWorkbench then
		errorString("Cannot get info on public screen\n");
		return(false);
	    fi;
	    TopBorder := NEW_TOP_BORDER;
	    LeftBorder := NEW_LEFT_BORDER;
	    RightBorder := NEW_RIGHT_BORDER;
	    BottomBorder := NEW_BOTTOM_BORDER;
	fi;
    fi;
    true
corp;

/*
 * selectFont - use the public screen or a temporary screen to determine
 *	the desired attributes of the font we will use.
 */

proc selectFont(**TextAttr_t pAttr; *uint pCharWidth)bool:
    register *Screen_t sc;
    register *TextFont_t tf;

    tf := GfxBase*.gb_DefaultFont;
    MyFont := nil;	/* set only when we need it */
    /* First, checkout the default font, to see if we like it. If not, we
       try to setup to get one we like better (TOPAZ 80) */

    pAttr* := nil;
    if OldStyle then
	sc := OpenScreen(&ExtNewScreen_t(
	    (0, 0, LORES_GRAPHICS_WIDTH, LORES_GRAPHICS_HEIGHT, 1,
	     0, 1, 0x0, CUSTOMSCREEN, nil, nil, nil, nil), nil
	));
    else
	sc := LockPubScreen(nil);
    fi;
    if sc = nil then
	errorString("Cannot check screen for default font\n");
	return(false);
    fi;
    pCharWidth* := TextLength(&sc*.sc_RastPort, "M", 1);
    if sc*.sc_Font = nil or
	sc*.sc_Font*.ta_YSize ~= CHAR_HEIGHT or
	sc*.sc_Font*.ta_Flags & (FPF_REVPATH | FPF_PROPORTIONAL) ~= 0 or
	TextLength(&sc*.sc_RastPort, "|", 1) ~= CHAR_WIDTH or
	TextLength(&sc*.sc_RastPort, "i", 1) ~= CHAR_WIDTH or
	TextLength(&sc*.sc_RastPort, "M", 1) ~= CHAR_WIDTH or
	tf = nil or tf*.tf_YSize ~= CHAR_HEIGHT or
	tf*.tf_XSize ~= CHAR_WIDTH or
	tf*.tf_Flags & (FPF_REVPATH | FPF_PROPORTIONAL) ~= 0
    then
	pAttr* := &StandardFont;
    fi;
    if OldStyle then
	CloseScreen(sc);
    else
	UnlockPubScreen(nil, sc);
    fi;
    true
corp;

/*
 * closeSomeStuff - avoid a bit of duplication.
 */

proc closeSomeStuff(uint howMany)void:
    register int tempWidth, tempHeight;

    WaitBlit();
    case howMany
    incase 7:
	if AslActive then
	    FreeAslRequest(AslReq);
	    CloseAslLibrary();
	fi;
    fallthrough:
    incase 6:
	CloseDevice(&IoStd.io_io);
    fallthrough:
    incase 5:
	case Mode
	incase md_oneWindow:
	    tempWidth := DisplayCols;
	    tempHeight := DisplayRows;
	incase md_twoWindow:
	    tempWidth := LeftBorder + GraphicsWidth + GraphicsRightBorder;
	    tempHeight := TopBorder + GraphicsHeight + BottomBorder;
	default:
	    tempWidth := GraphicsWidth;
	    tempHeight := GraphicsHeight;
	esac;
	FreeRaster(GraphicsTempPlane, tempWidth, tempHeight);
    fallthrough:
    incase 4:
	if Mode ~= md_oneWindow then
	    /* The port is shared with the text window */
	    GraphicsWindow*.w_UserPort := nil;
	    ModifyIDCMP(GraphicsWindow, 0x0);
	    CloseWindow(GraphicsWindow);
	    WaitBlit();
	fi;
    fallthrough:
    incase 3:
	if Mode = md_twoScreen then
	    CloseScreen(GraphicsScreen);
	fi;
    fallthrough:
    incase 2:
	CloseWindow(TextWindow);
	/* do this so early abort in main.d can close us down here to
	   free up memory, but its later call to 'abort' will not call
	   us again. */
	TextWindow := nil;
	WaitBlit();
    fallthrough:
    incase 1:
	if MyFont ~= nil then
	    CloseFont(MyFont);
	fi;
	if Mode = md_oneScreen or Mode = md_twoScreen then
	    CloseScreen(TextScreen);
	fi;
    esac;
    if not WorkBenchOn then
	ignore OpenWorkBench();
    fi;
corp;

/*
 * figureText - figure out all of the positions for text. Return the
 *	total height of the text window.
 */

proc figureText()uint:
    register uint vertExtra, horExtra, vertExtraPlus, textTotalHeight;
    register bool onWorkbench;

    onWorkbench := Mode = md_oneWindow or Mode = md_twoWindow;
    vertExtra := TopBorder + BottomBorder;
    vertExtraPlus := vertExtra;
    if Mode = md_oneWindow then
	vertExtraPlus := vertExtraPlus + WORKBENCH_SEP;
    fi;
    horExtra := LeftBorder + RightBorder;

    TextColumns := (DisplayCols - horExtra) / CHAR_WIDTH;
    if not onWorkbench then
	/* force it to be at least this wide - requires a bit of overscan */
	if TextColumns < TEXT_COLUMNS then
	    TextColumns := TEXT_COLUMNS;
	fi;
    fi;
    if TextColumns > MAX_TEXT_COLUMNS then
	TextColumns := MAX_TEXT_COLUMNS;
    fi;
    TextWidth := TextColumns * CHAR_WIDTH + horExtra;
    /* RightEdge is the coordinate for scrolls and clears in the window. */
    RightEdge := TextWidth - RightBorder - 1;

    if Mode = md_oneWindow then
	TextTop := TopBorder + GraphicsHeight + WORKBENCH_SEP;
    else
	TextTop := TopBorder;
    fi;

    TextFullLines := (DisplayRows - vertExtraPlus) / CHAR_HEIGHT;
    if not onWorkbench then
	/* force it to be at least this high - requires a bit of overscan */
	if TextFullLines < 23 then
	    TextFullLines := 23;
	fi;
    fi;
    TextFullHeight := TextFullLines * CHAR_HEIGHT + vertExtraPlus;
    TextFullOutputRow := TextFullHeight - BottomBorder -
	(CHAR_HEIGHT * 2 - CHAR_BASELINE);
    TextFullInputBottom := TextFullHeight - BottomBorder;
    TextFullInputTop := TextFullInputBottom - CHAR_HEIGHT;
    TextFullInputBottom := TextFullInputBottom - 1;

    TextHalfLines := (DisplayRows - ScreenDelta - vertExtra) / CHAR_HEIGHT;
    TextHalfHeight := TextHalfLines * CHAR_HEIGHT + vertExtra;
    TextHalfOutputRow := TextHalfHeight - BottomBorder -
	(CHAR_HEIGHT * 2 - CHAR_BASELINE);
    TextHalfInputBottom := TextHalfHeight - BottomBorder;
    if Mode = md_oneWindow then
	TextHalfOutputRow :=
	    TextHalfOutputRow + GraphicsHeight + WORKBENCH_SEP;
	TextHalfInputBottom :=
	    TextHalfInputBottom + GraphicsHeight + WORKBENCH_SEP;
    elif Mode = md_twoWindow then
	TextHalfOutputRow := TextFullOutputRow;
	TextHalfInputBottom := TextFullInputBottom + 1;
    fi;
    TextHalfInputTop := TextHalfInputBottom - CHAR_HEIGHT;
    TextHalfInputBottom := TextHalfInputBottom - 1;

    LineDifference := TextFullLines - TextHalfLines;
    textTotalHeight := TextHalfHeight + ScreenDelta;
    if TextFullHeight > textTotalHeight then
	textTotalHeight := TextFullHeight;
    fi;
    textTotalHeight
corp;

/*
 * setupPens - setup the various drawing pens. Part of openTextStuff.
 */

proc setupPens(*uint pPens)void:
    register *DrawInfo_t dri;
    register *Screen_t sc;
    register uint penCount;

    penCount := 0;
    ErasePen := ERASE_PEN;
    PromptPen := DARK_PEN;
    if OldStyle then
	TextPen := CST_TEXT_PEN;
    else
	sc := LockPubScreen(nil);
	if sc ~= nil then
	    dri := GetScreenDrawInfo(sc);
	    if dri ~= nil then
		penCount := dri*.dri_NumPens;
		if penCount > NUMDRIPENS then
		    penCount := NUMDRIPENS;
		fi;
		BlockCopy(pPens, dri*.dri_Pens, penCount * sizeof(uint));
		FreeScreenDrawInfo(sc, dri);
	    fi;
	    UnlockPubScreen(nil, sc);
	fi;
	TextPen := STD_TEXT_PEN;
	if penCount >= BACKGROUNDPEN + 1 then
	    ErasePen := (pPens + BACKGROUNDPEN * sizeof(uint))*;
	fi;
	if penCount >= TEXTPEN + 1 then
	    TextPen := (pPens + TEXTPEN * sizeof(uint))*;
	fi;
	if penCount >= HIGHLIGHTTEXTPEN + 1 then
	    PromptPen := (pPens + HIGHLIGHTTEXTPEN * sizeof(uint))*;
	fi;
    fi;
    (pPens + penCount * sizeof(uint))* := 0xffff;
corp;

/*
 * drawSeparator - draw the Workbench separator lines.
 */

proc drawSeparator()void:
    register *RastPort_t rp;
    register uint xl, xr, y;

    rp := TextRastPort;
    xl := LeftBorder;
    xr := DisplayCols - RightBorder;
    /* Draw the separator lines. This is why WORKBENCH_SEP is 3. */
    y := TopBorder + GraphicsHeight;
    SetAPen(rp, PromptPen);
    Move(rp, xl, y);
    Draw(rp, xr, y);
    y := y + 1;
    SetAPen(rp, TextPen);
    Move(rp, xl, y);
    Draw(rp, xr, y);
    y := y + 1;
    SetAPen(rp, PromptPen);
    Move(rp, xl, y);
    Draw(rp, xr, y);
    SetAPen(rp, TextPen);
corp;

/*
 * openTextStuff - open up text (screen and) window.
 */

proc openTextStuff(*TextAttr_t desiredAttr; *uint pens; bool bright, _dim)bool:
    ExtNewScreen_t ens;
    NewWindow_t nw;
    [2]TagItem_t ti;
    register *Screen_t sc;
    register *Window_t win;
    register *RastPort_t rp @ sc;
    uint totalHeight;

    totalHeight := figureText();

    /* Get the text code to setup the scrollbar, etc. */
    tx_init0();

    if Mode = md_oneWindow or Mode = md_twoWindow then
	nw := NewWindow_t(
	    0, 0, 0, 0, ERASE_PEN, LIGHT_PEN, 0x0, 0x0,
	    nil, nil, nil, nil, nil, 0, 0, 0, 0, WBENCHSCREEN);
	nw.nw_Width := DisplayCols;
	nw.nw_Height := DisplayRows;
	if Mode = md_oneWindow then
	    nw.nw_IDCMPFlags :=
		NEWSIZE | MENUPICK | CLOSEWINDOW | RAWKEY |
		    MOUSEMOVE | MOUSEBUTTONS | GADGETDOWN | GADGETUP;
	    nw.nw_Flags :=
		WINDOWDRAG | WINDOWDEPTH | WINDOWCLOSE | NOCAREREFRESH |
		    WINDOWSIZING | SIZEBRIGHT | SMART_REFRESH | ACTIVATE;
	    nw.nw_MinWidth := GraphicsWidth + LeftBorder + RightBorder;
	    nw.nw_MinHeight := GraphicsHeight + WORKBENCH_SEP + TopBorder +
		    BottomBorder + 5 * CHAR_HEIGHT;
	else
	    if HiRes then
		/* Put the text window below the graphics window. */
		nw.nw_TopEdge := FullDisplayRows - nw.nw_Height;
		totalHeight := GraphicsHeight + TopBorder + BottomBorder;
		if nw.nw_TopEdge > totalHeight then
		    nw.nw_TopEdge := totalHeight;
		fi;
	    fi;
	    nw.nw_IDCMPFlags :=
		NEWSIZE | MENUPICK | CLOSEWINDOW | RAWKEY | REFRESHWINDOW |
		    MOUSEMOVE | GADGETDOWN | GADGETUP;
	    nw.nw_Flags :=
		WINDOWDRAG | WINDOWDEPTH | WINDOWCLOSE |
		    WINDOWSIZING | SIZEBRIGHT | SIMPLE_REFRESH | ACTIVATE;
	    /* Need these minimums - see edit.d/ed_showHelp. */
	    nw.nw_MinWidth := LeftBorder + RightBorder + 25 * CHAR_WIDTH;
	    nw.nw_MinHeight := TopBorder + BottomBorder + 4 * CHAR_HEIGHT;
	fi;
	if OS3 then
	    nw.nw_DetailPen := TextPen;
	    nw.nw_BlockPen := PromptPen;
	    nw.nw_Flags := nw.nw_Flags | 0x00200000; /* WFLG_NEWLOOKMENUS */
	fi;
	nw.nw_MaxWidth := 0x7fff;
	nw.nw_MaxHeight := 0x7fff;
	if desiredAttr ~= nil then
	    MyFont := OpenFont(desiredAttr);
	fi;
    else
	ens := ExtNewScreen_t(
	    (0, 0, 0, 0, TEXT_DEPTH,
	     ERASE_PEN, LIGHT_PEN, 0x0, CUSTOMSCREEN,
	     nil, nil, nil, nil), nil
	);

	if not OldStyle then
	    ens.ens_ns.ns_Type := CUSTOMSCREEN | NS_EXTENDED;
	fi;

	if Mode = md_oneScreen then
	    ens.ens_ns.ns_Depth := GRAPHICS_DEPTH + 1;
	else
	    ens.ens_ns.ns_TopEdge := ScreenDelta;
	fi;
	ens.ens_ns.ns_Width := TextWidth;
	ens.ens_ns.ns_Height := totalHeight;
	if HiRes then
	    ens.ens_ns.ns_ViewModes := LACE | HIRES;
	else
	    ens.ens_ns.ns_ViewModes := HIRES;
	fi;
	ens.ens_ns.ns_Font := desiredAttr;
	ens.ens_ns.ns_LeftEdge := (DisplayCols - TextWidth) / 2;

	ti[0] := TagItem_t(SA_Pens, 0);
	ti[1] := TagItem_t(TAG_END, 0);
	ti[0].ti_Data := pretend(pens, ulong);
	ens.ens_Extension := &ti[0];

	sc := OpenScreen(&ens);
	if sc = nil then
	    closeSomeStuff(0);
	    errorString("Cannot open text screen\n");
	    return(false);
	fi;
	TextScreen := sc;

	TextViewPort := &sc*.sc_ViewPort;
	if OldStyle then
	    LoadRGB4(TextViewPort,
		     if bright then
			 &BrightTextColourTable[0]
		     elif _dim then
			 &DimTextColourTable[0]
		     else
			 &RegularTextColourTable[0]
		     fi,
		     1 << TEXT_DEPTH);
	fi;

	nw := NewWindow_t(
	    0, 0, 0, 0, ERASE_PEN, LIGHT_PEN,
	    NEWSIZE | MENUPICK | CLOSEWINDOW | RAWKEY | MOUSEMOVE |
		REFRESHWINDOW | GADGETDOWN | GADGETUP | ACTIVEWINDOW |
		INACTIVEWINDOW,
	    WINDOWDEPTH | WINDOWCLOSE | SIMPLE_REFRESH | ACTIVATE,
	    nil, nil, nil, nil, nil, 0, 0, 0, 0, CUSTOMSCREEN);
	nw.nw_Screen := sc;

	nw.nw_Width := TextWidth;
	nw.nw_MinWidth := TextWidth;
	nw.nw_MaxWidth := TextWidth;
	if OldStyle then
	    nw.nw_Height := TextFullHeight;
	    nw.nw_MinHeight := TextFullHeight;
	    nw.nw_MaxHeight := TextFullHeight;
	else
	    nw.nw_Height := TextHalfHeight;
	    nw.nw_MinHeight := TextHalfHeight;
	    nw.nw_MaxHeight := TextHalfHeight;
	    if Mode = md_oneScreen then
		if HiRes then
		    nw.nw_TopEdge := HIRES_GRAPHICS_HEIGHT;
		else
		    nw.nw_TopEdge := LORES_GRAPHICS_HEIGHT;
		fi;
	    fi;
	fi;
    fi;

    /* and finally, open up our text window */

    nw.nw_Title := "MUD client V\(VERSION1).\(VERSION2) "
	"Copyright 19\(YEAR1)\(YEAR2) by Chris Gray";
    nw.nw_FirstGadget := ScrollGadget;
    win := OpenWindow(&nw);
    if win = nil then
	closeSomeStuff(1);
	errorString("Cannot open text window\n");
	return(false);
    fi;
    rp := win*.w_RPort;
    TextWindow := win;
    TextRastPort := rp;
    SetDrMd(rp, JAM1);
    SetAPen(rp, TextPen);
    SetBPen(rp, ErasePen);
    if Mode = md_oneWindow or Mode = md_twoWindow then
	if Mode = md_oneWindow then
	    drawSeparator();
	fi;
	if MyFont ~= nil then
	    SetFont(rp, MyFont);
	fi;
	TextViewPort := &win*.w_WScreen*.sc_ViewPort;
    fi;
    true
corp;

proc setTextPen(uint which, colour)void:

    if OldStyle then
	if which < 1 << TEXT_DEPTH then
	    SetRGB4(TextViewPort, which,
		    (colour >> 8) & 0xf, (colour >> 4) & 0xf, colour & 0xf);
	fi;
    fi;
corp;

/* Stuff for dealing with the graphics window, and screen if present. */

proc zapArea()void:
    register uint i;
    register *uint p;

    p := &GraphicsAreaBuf[0];
    for i from AREA_SIZE - 1 downto 0 do
	p* := 0;
	p := p + sizeof(uint);
    od;
corp;

/*
 * setGraphicsPen - depends on 'OneScreen'.
 */

proc setGraphicsPen(uint pen, colour)void:

    if Mode = md_oneScreen then
	SetRGB4(TextViewPort, pen + GRAPHICS_COLOURS,
	    (colour >> 8) & 0xf, (colour >> 4) & 0xf, colour & 0xf);
    elif Mode = md_twoScreen then
	SetRGB4(&GraphicsScreen*.sc_ViewPort, pen,
	    (colour >> 8) & 0xf, (colour >> 4) & 0xf, colour & 0xf);
    fi;
corp;

/*
 * setGraphicsPalette - set the full palette for graphics.
 */

proc setGraphicsPalette(register *uint palette; uint colourCount)void:
    register uint pen;

    if colourCount > GRAPHICS_COLOURS then
	colourCount := GRAPHICS_COLOURS;
    fi;
    if Mode = md_oneScreen then
	for pen from 0 upto colourCount - 1 do
	    setGraphicsPen(pen, (palette + pen * sizeof(uint))*);
	od;
    elif Mode = md_twoScreen then
	LoadRGB4(&GraphicsScreen*.sc_ViewPort, palette, colourCount);
    fi;
corp;

/*
 * resetColours - reset the graphics screen to its default colours.
 */

proc resetColours()void:

    setGraphicsPalette(&GraphicsColourTable[0], GRAPHICS_COLOURS);
corp;

/*
 * setGraphicsAPen - select the current pen for graphics.
 */

proc setGraphicsAPen(uint pen)void:

    if Mode = md_oneScreen then
	pen := pen + GRAPHICS_COLOURS;
    fi;
    SetAPen(GraphicsRastPort, pen);
corp;

/*
 * setGraphicsBPen - select the current pen for graphics.
 */

proc setGraphicsBPen(uint pen)void:

    if Mode = md_oneScreen then
	pen := pen + GRAPHICS_COLOURS;
    fi;
    SetBPen(GraphicsRastPort, pen);
corp;

/*
 * setGraphicsRast - do a SetRast.
 */

proc setGraphicsRast(uint pen)void:
    register *RastPort_t rp;
    ushort savePen;

    case Mode
    incase md_oneWindow:
    incase md_twoWindow:
	rp := GraphicsRastPort;
	savePen := rp*.rp_FgPen;
	SetAPen(rp, pen);
	RectFill(rp, GXOffset, GYOffset, GXOffset + GraphicsWidth - 1,
		 GYOffset + GraphicsHeight - 1);
	SetAPen(rp, savePen);
    incase md_oneScreen:
	SetRast(GraphicsRastPort, pen + GRAPHICS_COLOURS);
    incase md_twoScreen:
	SetRast(GraphicsRastPort, pen);
    esac;
corp;

/*
 * getColourMap - fill in a passed colour map with the current/default colours.
 */

proc getColourMap(register *uint map; bool wantDefault)void:
    register *ColorMap_t cm;
    register uint i;

    if wantDefault then
	BlockCopy(map, &GraphicsColourTable[0],
		  GRAPHICS_COLOURS * sizeof(uint));
    else
	case Mode
	incase md_oneWindow:
	incase md_twoWindow:
	    cm := TextViewPort*.vp_ColorMap;
	    for i from 0 upto ColourCount - 1 do
		map* := GetRGB4(cm, i);
		map := map + sizeof(uint);
	    od;
	incase md_oneScreen:
	    cm := TextViewPort*.vp_ColorMap;
	    for i from 0 upto GRAPHICS_COLOURS - 1 do
		map* := GetRGB4(cm, i + GRAPHICS_COLOURS);
		map := map + sizeof(uint);
	    od;
	incase md_twoScreen:
	    cm := GraphicsScreen*.sc_ViewPort.vp_ColorMap;
	    for i from 0 upto GRAPHICS_COLOURS - 1 do
		map* := GetRGB4(cm, i);
		map := map + sizeof(uint);
	    od;
	esac;
    fi;
corp;

/*
 * openGraphicsStuff - maybe open up the graphics (screen and) window.
 */

proc openGraphicsStuff(*TextAttr_t desiredAttr)bool:
    ExtNewScreen_t ens;
    NewWindow_t nw;
    register *Screen_t sc;
    register *RastPort_t rp;
    register uint tempWidth, tempHeight;
    *Window_t win;

    if Mode = md_oneWindow then
	GraphicsWindow := TextWindow;
	rp := TextRastPort;
	GraphicsRastPort := rp;
    else
	if Mode = md_oneScreen then
	    GraphicsScreen := nil;
	    sc := TextScreen;
	    ShowTitle(sc, 0);
	elif Mode = md_twoScreen then
	    ens := ExtNewScreen_t(
		(0, 0, 0, 0, GRAPHICS_DEPTH,
		 0, 1, 0x0, CUSTOMSCREEN | SCREENQUIET,
		 nil, nil, nil, nil), nil
	    );
	    ens.ens_ns.ns_Width := GraphicsWidth;
	    ens.ens_ns.ns_Height := GraphicsHeight;
	    ens.ens_ns.ns_Font := desiredAttr;
	    ens.ens_ns.ns_DefaultTitle := "";
	    if HiRes then
		ens.ens_ns.ns_LeftEdge := (DisplayCols - GraphicsWidth) / 2;
		ens.ens_ns.ns_ViewModes := LACE | HIRES;
	    else
		ens.ens_ns.ns_LeftEdge :=
		    (DisplayCols / 2 - GraphicsWidth) / 2;
		ens.ens_ns.ns_ViewModes := 0x0;
	    fi;
	    sc := OpenScreen(&ens);
	    if sc = nil then
		closeSomeStuff(2);
		errorString("Cannot open graphics screen\n");
		return(false);
	    fi;
	    ScreenToFront(TextScreen);

	    GraphicsScreen := sc;
	    ShowTitle(sc, 0);
	fi;
	resetColours();

	/* and the window we put on the screen */

	nw := NewWindow_t(0, 0, 0, 0, 0, 1, 0x0, 0x0,
			  nil, nil, nil, nil, nil, 0, 0, 0, 0, 0);
	case Mode
	incase md_oneScreen:
	    nw.nw_Screen := sc;
	    nw.nw_Width := TextWidth;
	    nw.nw_Height := GraphicsHeight;
	    nw.nw_Flags := BORDERLESS | BACKDROP | SMART_REFRESH |
		NOCAREREFRESH;
	    /* We want to center the graphics stuff in the width of the
	       area for it. Since the bitmap for it is actually shared
	       from the text screen, we need GXOffset set properly so
	       that things like BltBitMap will work correctly. That in
	       turn requires that the graphics window be full width so
	       that GXOffset works for RastPort-only operations. */
	    GXOffset := (TextWidth - GraphicsWidth) / 2;
	    nw.nw_Type := CUSTOMSCREEN;
	incase md_twoScreen:
	    nw.nw_Screen := sc;
	    nw.nw_Width := GraphicsWidth;
	    nw.nw_Height := GraphicsHeight;
	    nw.nw_Flags := BORDERLESS | BACKDROP | SMART_REFRESH | RMBTRAP |
		NOCAREREFRESH;
	    nw.nw_Type := CUSTOMSCREEN;
	incase md_twoWindow:
	    nw.nw_Width := GraphicsWidth + LeftBorder + GraphicsRightBorder;
	    nw.nw_Height := GraphicsHeight + TopBorder + BottomBorder;
	    if not HiRes then
		/* Put graphics window in upper right of text window. */
		nw.nw_LeftEdge := DisplayCols - RightBorder - nw.nw_Width;
		if make(nw.nw_LeftEdge, int) < 0 then
		    nw.nw_LeftEdge := 0;
		fi;
		nw.nw_TopEdge := TopBorder;
	    fi;
	    nw.nw_Flags :=
		WINDOWDRAG | WINDOWDEPTH | SMART_REFRESH | NOCAREREFRESH;
	    if OS3 then
		nw.nw_DetailPen := TextPen;
		nw.nw_BlockPen := PromptPen;
		nw.nw_Flags := nw.nw_Flags | 0x00200000; /* WFLG_NEWLOOKMENUS*/
	    fi;
	    nw.nw_Type := WBENCHSCREEN;
	    nw.nw_Title :=
		if HiRes then
		    "MUD client V\(VERSION1).\(VERSION2) "
			"Copyright 19\(YEAR1)\(YEAR2) by Chris Gray"
		else
		    "MUD client V\(VERSION1).\(VERSION2) by Chris Gray"
		fi;
	esac;
	nw.nw_MinWidth := nw.nw_Width;
	nw.nw_MinHeight := nw.nw_Height;
	nw.nw_MaxWidth := nw.nw_Width;
	nw.nw_MaxHeight := nw.nw_Height;
	win := OpenWindow(&nw);
	if win = nil then
	    closeSomeStuff(3);
	    errorString("Cannot open graphics window\n");
	    return(false);
	fi;
	GraphicsWindow := win;
	rp := win*.w_RPort;
	GraphicsRastPort := rp;
	win*.w_UserPort := TextWindow*.w_UserPort;
	case Mode
	incase md_oneScreen:
	incase md_twoWindow:
	    ModifyIDCMP(win, RAWKEY | MOUSEMOVE | MOUSEBUTTONS | MENUPICK);
	incase md_twoScreen:
	    ModifyIDCMP(win, RAWKEY | MOUSEMOVE | MOUSEBUTTONS);
	esac;

	setGraphicsRast(0);
	SetDrMd(rp, JAM1);
	if Mode = md_twoWindow and HiRes then
	    /* In case we just hid some of it. */
	    WindowToFront(TextWindow);
	fi;
    fi;
    SetAfPt(rp, nil, 1);

    /* build an AreaInfo for use with the area fill routines */

    zapArea();
    InitArea(&GraphicsAreaInfo, &GraphicsAreaBuf[0], AREA_SIZE * 2 / 5);
    case Mode
    incase md_oneWindow:
	tempWidth := DisplayCols;
	tempHeight := DisplayRows;
    incase md_twoWindow:
	tempWidth := LeftBorder + GraphicsWidth + GraphicsRightBorder;
	tempHeight := TopBorder + GraphicsHeight + BottomBorder;
    default:
	tempWidth := GraphicsWidth;
	tempHeight := GraphicsHeight;
    esac;
    GraphicsTempPlane := AllocRaster(tempWidth, tempHeight);
    if GraphicsTempPlane = nil then
	closeSomeStuff(4);
	return(false);
    fi;
    InitTmpRas(&GraphicsTmpRas, GraphicsTempPlane,
	       RASSIZE(tempWidth, tempHeight));
    rp*.rp_AreaInfo := &GraphicsAreaInfo;
    rp*.rp_TmpRas := &GraphicsTmpRas;

    true
corp;

proc initKeyBoardStuff()bool:
    register *[128] uint kmt;
    register uint i;

    /* we need the console device in order to do RawKeyConvert calls */

    if OpenDevice("console.device", -1, &IoStd.io_io, 0) ~= 0 then
	tx_term();
	closeSomeStuff(5);
	errorString("Cannot open console.device\n");
	return(false);
    fi;
    SetConsoleDevice(IoStd.io_io.io_Device);
    kmt := &KeyMapTable;
    for i from 127 downto 0 do
	kmt*[i] := 0;
    od;
    kmt*[0x4c] := KEY_UP;
    kmt*[0x4d] := KEY_DOWN;
    kmt*[0x4e] := KEY_RIGHT;
    kmt*[0x4f] := KEY_LEFT;
    for i from 1 upto 10 do
	kmt*[0x4f + i] := KEY_FUNC + i;
    od;
    kmt*[0x5f] := KEY_HELP;
    kmt*[0x3d] := KEY_KP_UL;
    kmt*[0x3e] := KEY_KP_U;
    kmt*[0x3f] := KEY_KP_UR;
    kmt*[0x2d] := KEY_KP_L;
    kmt*[0x2e] := KEY_KP_C;
    kmt*[0x2f] := KEY_KP_R;
    kmt*[0x1d] := KEY_KP_DL;
    kmt*[0x1e] := KEY_KP_D;
    kmt*[0x1f] := KEY_KP_DR;
    kmt*[0x5e] := KEY_KP_PLUS;
    kmt*[0x4a] := KEY_KP_MINUS;
    true
corp;

/*
 * initAslReq - setup for using asl.library if we can.
 */

proc initAslReq()void:
    [2] TagItem_t tagItems;

    tagItems[0].ti_Tag := ASLFR_Window;
    tagItems[0].ti_Data := pretend(TextWindow, ulong);
    tagItems[1] := TagItem_t(TAG_END, 0);
    AslActive := false;
    if Mode ~= md_twoScreen or HiRes then
	if OpenAslLibrary(37) ~= nil then
	    AslReq := AllocAslRequest(ASL_FileRequest, &tagItems[0]);
	    if AslReq ~= nil then
		AslActive := true;
	    else
		CloseAslLibrary();
	    fi;
	fi;
    fi;
corp;

/*
 * intuitionInit - create all of our screens, windows, etc.
 */

proc intuitionInit(bool usingSerial, closeWorkbench, bright, _dim)bool:
    *TextAttr_t desiredAttr;
    uint charWidth;
    [NUMDRIPENS + 1] uint pens;

    TerminalMode := usingSerial;

    /* how big is the user's normal working screen? */

    if Mode = md_oneScreen or Mode = md_twoScreen then
	getBaseSizes();
    fi;

    if not selectFont(&desiredAttr, &charWidth) then
	return(false);
    fi;

    /* Select the various border sizes, and the graphics sizes. */

    if not setSizes() then
	return(false);
    fi;

    /* Get info on the drawing pens. */
    setupPens(&pens[0]);

    /* This must be done after the above CloseScreen, so that the system
       doesn't automatically open the workbench when it notices there is
       no screen left. Also has to be done after 'setSizes', which uses
       the default public screen. */
    WorkBenchOn := true;
    if closeWorkbench then
	if CloseWorkBench() then
	    WorkBenchOn := false;
	    OptionsItems[1].mi_Flags := OptionsItems[1].mi_Flags & ~CHECKED;
	fi;
    fi;

    /* Need this fairly early - for the call to tx_init0 in openTextStuff */

    PictureShown := true;

    /* Open up our text screen and window. */

    if not openTextStuff(desiredAttr, &pens[0], bright, _dim) then
	return(false);
    fi;

    /* Do this after openTextStuff, so have proper pens for newlook. */
    fixMenus(usingSerial, desiredAttr, charWidth);

    /* Open up our graphics screen and window. This is done *after* the text
       stuff since in 'OneScreen' mode we need the text screen. */

    if not openGraphicsStuff(desiredAttr) then
	return(false);
    fi;

    /* Everything created, initialization can continue. */

    GraphicsOn := true;
    SoundOn := true;
    MusicOn := true;
    VoiceOn := true;
    Logging := false;
    LogFileName[0] := '\e';
    SourceFileName[0] := '\e';
    SnapFileName[0] := '\e';
    LogDir[0] := '\e';
    SourceDir[0] := '\e';
    SnapDir[0] := '\e';
    Editing := false;
    Scrolling := false;
    HadRAB := false;
    SourceFd := 0;
    EditToggle := false;
    SkipRefresh := false;
    WantRefresh := false;

    if not tx_init1() then
	closeSomeStuff(5);
	return(false);
    fi;
    ed_init();
    MainMenu := &Menus[0];
    SetMenuStrip(TextWindow, MainMenu);
    if Mode = md_oneScreen or Mode = md_twoWindow then
	SetMenuStrip(GraphicsWindow, MainMenu);
    fi;
    if not usingSerial then
	OnMenu(TextWindow, SHIFTMENU(0) | SHIFTITEM(3));
    fi;

    if not initKeyBoardStuff() then
	return(false);
    fi;

    initAslReq();

    if not effectsInit() then
	tx_term();
	closeSomeStuff(7);
	return(false);
    fi;

    displayIntro();

    true
corp;

proc putProtStr1()void:
    byte K1 = 0xA5, K2 = 0xc4, K3 = 0x67;
    *char STRING =
	"\(('A'-'\e')><K1)\(('m'-'\e')><K2)\(('i'-'\e')><K3)"
	"\(('g'-'\e')><K1)\(('a'-'\e')><K2)\(('M'-'\e')><K3)"
	"\(('U'-'\e')><K1)\(('D'-'\e')><K2)\((' '-'\e')><K3)"
	"\(('V'-'\e')><K1)\((VERSION1-'\e')><K2)\(('.'-'\e')><K3)"
	"\((VERSION2-'\e')><K1)\((' '-'\e')><K2)\(('C'-'\e')><K3)"
	"\(('o'-'\e')><K1)\(('p'-'\e')><K2)\(('y'-'\e')><K3)"
	"\(('r'-'\e')><K1)\(('i'-'\e')><K2)\(('g'-'\e')><K3)"
	"\(('h'-'\e')><K1)\(('t'-'\e')><K2)\((' '-'\e')><K3)"
	"\(('1'-'\e')><K1)\(('9'-'\e')><K2)\((YEAR1-'\e')><K3)"
	"\((YEAR2-'\e')><K1)\((' '-'\e')><K2)\(('b'-'\e')><K3)"
	"\(('y'-'\e')><K1)\((' '-'\e')><K2)\(('C'-'\e')><K3)"
	"\(('h'-'\e')><K1)\(('r'-'\e')><K2)\(('i'-'\e')><K3)"
	"\(('s'-'\e')><K1)\((' '-'\e')><K2)\(('G'-'\e')><K3)"
	"\(('r'-'\e')><K1)\(('a'-'\e')><K2)\(('y'-'\e')><K3)"
	"\((' '-'\e')><K1)\((' '-'\e')><K2)\(('\n'-'\e')><K3)";

    register *char p;
    register char ch;
    register proc(char ch)void r_putChar;

    HadRAB := false;
    p := STRING;
    r_putChar := putChar;
    while
	ch := p*;
	p := p + sizeof(char);
	ch ~= '\e'
    do
	ch := (ch - '\e') >< K1 + '\e';
	r_putChar(ch);
	ch := p*;
	p := p + sizeof(char);
	ch := (ch - '\e') >< K2 + '\e';
	r_putChar(ch);
	ch := p*;
	p := p + sizeof(char);
	ch := (ch - '\e') >< K3 + '\e';
	r_putChar(ch);
    od;
corp;

/*
 * intuitionTerm - shut down our screens, windows, etc.
 *	Assumption: not called if 'intuitionInit' failed.
 */

proc intuitionTerm()void:

    if Logging then
	logOff();
    fi;
    if SourceFd ~= 0 then
	Close(SourceFd);
    fi;
    ed_freeBuffer();
    tx_term();
    effectsTerm(false);
    closeSomeStuff(7);
corp;

/*
 * doPictureMenu - enable/disable the 'Picture' menu for editing.
 */

proc doPictureMenu()void:

    if Mode = md_oneScreen or Mode = md_twoScreen then
	if Editing then
	    OffMenu(TextWindow, SHIFTMENU(1) | SHIFTITEM(3) | SHIFTSUB(NOSUB));
	else
	    OnMenu(TextWindow, SHIFTMENU(1) | SHIFTITEM(3) | SHIFTSUB(NOSUB));
	fi;
    fi;
    EditToggle := true;
corp;

/*
 * removeMenus - disable our menu set - we are shutting down.
 */

proc removeMenus()void:

/*
    ClearMenuStrip(TextWindow);
*/
corp;

/*
 * getEffects interface to describe the effects we can handle.
 */

proc getEffects(register *EffectsInfo_t ei)void:
    register *char p @ ei, q;

    /* note that ei WILL be word aligned */
    ei*.ei_graphicsRows := GraphicsHeight;
    ei*.ei_graphicsCols := GraphicsWidth;
    ei*.ei_graphicsColours :=
	if MapColours then
	    GRAPHICS_COLOURS
	else
	    ColourCount
	fi;
    ei*.ei_textWidth := TextColumns;
    ei*.ei_textHeight :=
	if Mode = md_oneWindow or Mode = md_twoWindow then
	    TextHalfLines
	else
	    TextFullLines
	fi;
    ei*.ei_version := (VERSION1 - '0') * 10 + (VERSION2 - '0');
    ei*.ei_canEdit := not DisableEdit;
    ei*.ei_canGetString := true;
    ei*.ei_canQueryFile := true;
    ei*.ei_canWizard := true;
    ei*.ei_graphicsOn := GraphicsOn;
    ei*.ei_graphicsPalette :=
	Mode = md_oneScreen or Mode = md_twoScreen or MapColours;
    ei*.ei_voiceOn := VoiceOn;
    ei*.ei_soundOn := SoundOn;
    ei*.ei_musicOn := MusicOn;
    p := &ei*.ei_graphicsType[0];
    q := "Amiga";
    while
	p* := q*;
	p := p + sizeof(char);
	q* ~= '\e'
    do
	q := q + sizeof(char);
    od;
corp;

/*
 * handleRefresh - handle a REFRESHWINDOW IDCMP event.
 */

proc handleRefresh()void:

    /* Note: rules say that only simple drawing actions should be done
       between BeginRefresh and EndRefresh. In particular, no gadget
       redraw, or border refresh type stuff. My routines seem safe, with
       the only question being about the NewModifyProp in ed_refresh. */
    BeginRefresh(TextWindow);
    if Editing then
	ed_refresh();
    else
	tx_refresh();
    fi;
    EndRefresh(TextWindow, -1);
corp;

/*
 * stringRequest - use a simple string requester to get a file name, etc.
 *	Return 'false' if user clicked on CANCEL, else return 'true'.
 */

proc stringRequest(*char buffer; *IntuiText_t prompt; uint len)bool:
    register *IntuiMessage_t im;
    register *Window_t win;
    *Gadget_t gad;
    Requester_t r;
    ulong oldIDCMP, class;
    bool quit, cancelled;

    cancelled := false;
    win := TextWindow;
    InitRequester(&r);
    r.r_LeftEdge := (TextWidth - STRING_REQ_WIDTH - ScrollWidth) / 2;
    r.r_TopEdge := (TextHalfHeight - STRING_REQ_HEIGHT) / 2;
    r.r_Width := STRING_REQ_WIDTH;
    r.r_Height := STRING_REQ_HEIGHT;
    r.r_ReqGadget := &StringReqGadget;
    r.r_BackFill := DARK_PEN;
    r.r_RWindow := win;
    r.r_ReqText := prompt;
    r.r_ReqBorder := &StringReqBorder;
    /* Draco initialized variables doesn't handle these unions */
    StringReqGadget.g_SpecialInfo.gStr := &StringInfo;
    StringCancelGadget.g_GadgetRender.gBorder := &StringCancelBorder;
    /* or to these non-data objects */
    StringInfo.si_Buffer := buffer;
    StringInfo.si_UndoBuffer := &StringUndo[0];
    StringInfo.si_MaxChars := len;
    oldIDCMP := win*.w_IDCMPFlags;
    ModifyIDCMP(win, GADGETUP | REQSET | REFRESHWINDOW);
    /* we can take a try at activating the window */
    ActivateWindow(win);
    if Request(&r, win) then
	quit := false;
	while not quit do
	    ignore Wait(1 << win*.w_UserPort*.mp_SigBit);
	    while
		im := pretend(GetMsg(win*.w_UserPort), *IntuiMessage_t);
		im ~= nil
	    do
		class := im*.im_Class;
		gad := pretend(im*.im_IAddress, *Gadget_t);
		ReplyMsg(&im*.im_ExecMessage);
		case class
		incase REQSET:
		    ignore ActivateGadget(&StringReqGadget, win, &r);
		incase GADGETUP:
		    if gad = &StringCancelGadget then
			buffer* := '\e';
			cancelled := true;
		    fi;
		    quit := true;
		incase REFRESHWINDOW:
		    /* This comes in when the requester is undrawn. */
		    handleRefresh();
		esac;
	    od;
	od;
	EndRequest(&r, win);
    fi;
    ModifyIDCMP(win, oldIDCMP);
    not cancelled
corp;

/*
 * fileRequest - use either asl.library or 'stringRequest' to get a filename.
 */

proc fileRequest(FileType_t typ)bool:
    *char title, dir, name, gadget;
    IntuiText_t promptText;
    [7] TagItem_t tagItems;

    case typ
    incase ft_source:
	dir := &SourceDir[0];
	name := &SourceFileName[0];
    incase ft_snap:
	dir := &SnapDir[0];
	name := &SnapFileName[0];
    incase ft_log:
	dir := &LogDir[0];
	name := &LogFileName[0];
    esac;
    if AslActive then
	case typ
	incase ft_source:
	    title := "Select source file";
	    gadget := "Source";
	incase ft_snap:
	    title := "Enter snapshot file name";
	    gadget := "Snapshot";
	incase ft_log:
	    title := "Enter log file name";
	    gadget := "Log";
	esac;
	tagItems[0].ti_Tag := ASLFR_TitleText;
	tagItems[0].ti_Data := pretend(title, ulong);
	tagItems[1].ti_Tag := ASLFR_InitialDrawer;
	tagItems[1].ti_Data := pretend(dir, ulong);
	tagItems[2].ti_Tag := ASLFR_InitialFile;
	tagItems[2].ti_Data := pretend(name, ulong);
	tagItems[3].ti_Tag := ASLFR_Flags1;
	tagItems[3].ti_Data :=
	    if typ ~= ft_source then FRF_DOSAVEMODE else 0 fi;
	tagItems[4].ti_Tag := ASLFR_PositiveText;
	tagItems[4].ti_Data := pretend(gadget, ulong);
	tagItems[5].ti_Tag := ASLFR_RejectIcons;
	tagItems[5].ti_Data := 1;
	tagItems[6].ti_Tag := TAG_END;
	tagItems[6].ti_Data := 0;
	if AslRequest(AslReq, &tagItems[0]) ~= 0 then
	    CharsCopyN(dir, AslReq*.fr_Drawer, DIR_MAX);
	    CharsCopyN(name, AslReq*.fr_File, FILE_NAME_MAX);
	    true
	else
	    false
	fi
    else
	case typ
	incase ft_source:
	    title := "Enter source file name:";
	incase ft_snap:
	    title := "Enter snapshot file name:"
	incase ft_log:
	    title := "Enter log file name:";
	esac;
	promptText := IntuiText_t(
	    STD_TEXT_PEN, DARK_PEN, JAM1, 8, 6, nil, nil, nil);
	promptText.it_IText := title;
	stringRequest(name, &promptText, FILE_NAME_MAX)
    fi
corp;

/*
 * getString - use a requester to do the 'GetString' server builtin.
 */

proc getString(*char prompt, initial; **char pRes)bool:
    IntuiText_t promptText;
    bool ok;

    if CharsLen(prompt) > 80 then
	return(false);
    fi;
    if CharsLen(initial) > REQUEST_MAX then
	return(false);
    fi;
    /* If we try to change these pens, then we should change them in all
       other IntuiText_t's as well! */
    promptText :=
	IntuiText_t(STD_TEXT_PEN, DARK_PEN, JAM1, 8, 6, nil, nil, nil);
    promptText.it_IText := prompt;
    CharsCopy(&RequestString[0], initial);
    ok := stringRequest(&RequestString[0], &promptText, REQUEST_MAX);
    if OldStyle then
	tx_drawBorders(0);
    fi;
    pRes* := &RequestString[0];
    ok
corp;

/*
 * doSource - handle the 'Source' request.
 */

proc doSource()void:
    [500] char buffer;
    register long max;
    register uint linePos;
    register *char p, q, limit;
    register char ch;

    if SourceFd = 0 then
	if fileRequest(ft_source) then
	    buildPath(&buffer[0], &SourceDir[0], &SourceFileName[0]);
	    if not doMUDSource(&buffer[0]) then
		SourceFd := Open(&buffer[0], MODE_READONLY);
		if SourceFd = 0 then
		    putString("::Can't open source file '");
		    putString(&buffer[0]);
		    putString("'\n");
		else
		    setSync(true);
		    putString("::Sourcing file '");
		    putString(&buffer[0]);
		    putString("'...\n");
		    linePos := 0;
		    q := &RawBuffer[0];
		    p := &SourceBuffer[0];
		    limit := p;
		    while
			if p = limit then
			    max := Read(SourceFd, &SourceBuffer[0],SOURCE_MAX);
			    if max > 0 then
				limit := &SourceBuffer[max];
				p := &SourceBuffer[0];
				true
			    else
				false
			    fi
			else
			    true
			fi
		    do
			ch := p*;
			p := p + sizeof(char);
			if ch = '\n' then
			    tx_inputLine(&RawBuffer[0], linePos);
			    checkMessages();
			    linePos := 0;
			    q := &RawBuffer[0];
			else
			    if linePos = RAW_MAX then
				tx_inputLine(&RawBuffer[0], linePos);
				checkMessages();
				linePos := 0;
				q := &RawBuffer[0];
			    fi;
			    q* := ch;
			    q := q + sizeof(char);
			    linePos := linePos + 1;
			fi;
		    od;
		    if linePos ~= 0 then
			tx_inputLine(&RawBuffer[0], linePos);
			checkMessages();
		    fi;
		    Close(SourceFd);
		    putString("::...done\n");
		    SourceFd := 0;
		    setSync(false);
		fi;
	    fi;
	fi;
    fi;
corp

/*
 * screenToBack - put our screens back behind any others.
 */

proc screenToBack()void:

    if Mode = md_oneScreen or Mode = md_twoScreen then
	/* This ordering of the calls is done so that the text
	   screen ends up in front of the graphics screen, which
	   it needs to be. Unfortunately, the first call leaves
	   the graphics screen the frontmost, and Intuition
	   insists on moving the pointer to be within it. Sigh. */
	ScreenToBack(TextScreen);
	if Mode = md_twoScreen then
	    ScreenToBack(GraphicsScreen);
	fi;
    fi;
corp;

/*
 * screenToFront - bring our screens back to the front.
 */

proc screenToFront()void:

    if Mode = md_oneScreen or Mode = md_twoScreen then
	if Mode = md_twoScreen then
	    ScreenToFront(GraphicsScreen);
	fi;
	ScreenToFront(TextScreen);
    fi;
corp;

/*
 * doEditWinState - enable/disable the Edit Win menu item.
 */

proc doEditWinState(bool enableIt)void:

    if enableIt then
	OnMenu(TextWindow, SHIFTMENU(1) | SHIFTITEM(8) | SHIFTSUB(NOSUB));
    else
	OffMenu(TextWindow, SHIFTMENU(1) | SHIFTITEM(8) | SHIFTSUB(NOSUB));
    fi;
corp;

/*
 * doShowPicture - make the graphics screen visible.
 *	Note that this is also called from 'ed_hide'.
 */

proc doShowPicture()void:

    if Mode = md_twoScreen then
	MoveScreen(TextScreen, 0, + ScreenDelta);
    fi;
    if not OldStyle then
	SizeWindow(TextWindow, 0, TextHalfHeight - TextFullHeight);
	/* All of the redraw will now be done in tx_redraw, as called
	   from the NEWSIZE IDCMP event. */
    fi;
    if Mode = md_oneScreen then
	/* Do this *after* the SizeWindow */
	MoveWindow(TextWindow, 0, + HIRES_GRAPHICS_HEIGHT);
    fi;
corp;

/*
 * doShowPictureFixMenu - doShowPicture plus fix menu item.
 */

proc doShowPictureFixMenu()void:

    ModesItems[3].mi_Flags := ModesItems[3].mi_Flags | CHECKED;
    doShowPicture();
    PictureShown := true;
    tx_graphicsOn();
corp;

/*
 * doHidePicture - make the graphics screen not visible.
 */

proc doHidePicture()void:

    if Mode = md_oneScreen then
	MoveWindow(TextWindow, 0, - HIRES_GRAPHICS_HEIGHT);
    else
	MoveScreen(TextScreen, 0, - ScreenDelta);
    fi;
    if not OldStyle then
	SizeWindow(TextWindow, 0, TextFullHeight - TextHalfHeight);
	/* Redraw is done by tx_redraw as called from refresh event */
    fi;
corp;

/*
 * doHidePictureFixMenu - doHidePicture plus fix menu item.
 */

proc doHidePictureFixMenu()void:

    ModesItems[3].mi_Flags := ModesItems[3].mi_Flags & ~ CHECKED;
    doHidePicture();
    PictureShown := false;
    tx_graphicsOff();
corp;

/*
 * setTerminalMode - start playing dumb terminal program.
 */

proc setTerminalMode()void:

    tx_resetVars();
    TerminalMode := true;
    SetDrMd(TextRastPort, JAM2);
    /* re-enable the serial menu items */
    OnMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(0));
    OnMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(1) | SHIFTSUB(NOSUB));
    OnMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(2));
    OnMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(3));
    /* disable the Source menu item */
    OffMenu(TextWindow, SHIFTMENU(0) | SHIFTITEM(3));
    if Mode = md_oneScreen or Mode = md_twoScreen then
	if PictureShown then
	    doHidePictureFixMenu();
	fi;
    fi;
corp;

/*
 * clearTerminalMode - we are done playing dumb terminal program.
 */

proc clearTerminalMode()void:

    tx_resetVars();
    TerminalMode := false;
    SetDrMd(TextRastPort, JAM1);
    /* disable most of the Serial menu items */
    OffMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(0));
    OffMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(1) | SHIFTSUB(NOSUB));
    OffMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(2));
    OffMenu(TextWindow, SHIFTMENU(3) | SHIFTITEM(3));
    /* enable the Source menu item */
    OnMenu(TextWindow, SHIFTMENU(0) | SHIFTITEM(3));
    if Mode = md_oneScreen or Mode = md_twoScreen then
	if not PictureShown then
	    doShowPictureFixMenu();
	fi;
    fi;
corp;

/*
 * voiceOff - perhaps disable voice. Also used from sound.d
 */

proc voiceOff()void:

    VoiceOn := false;
    ModesItems[7].mi_Flags := ModesItems[7].mi_Flags & ~CHECKED;
    if not TerminalMode then
	vFlip(false);
    fi;
corp;

/*
 * doGraphicsSnap - take a snapshot of the graphics.
 */

proc doGraphicsSnap()void:
    [MAX_COLOURS] uint colourTable;
    [500] char name;

    if fileRequest(ft_snap) then
	buildPath(&name[0], &SnapDir[0], &SnapFileName[0]);
	getColourMap(&colourTable[0], false);
	iffDumpILBM(&name[0], GraphicsRastPort,
		    &colourTable[0], Mode = md_oneScreen);
    fi;
corp;

/*
 * doProjectMenu - part of doMenuPick.
 */

proc doProjectMenu(register uint which)bool:
    bool wantContinue;

    wantContinue := true;
    case ITEMNUM(which)
    incase 0:
	/* Log */
	if Logging then
	    logOff();
	    Logging := false;
	else
	    if LogFileName[0] ~= '\e' or fileRequest(ft_log) then
		if logOn(&LogDir[0], &LogFileName[0]) then
		    Logging := true;
		fi;
	    fi;
	    if not Logging then
		ProjectItems[0].mi_Flags :=ProjectItems[0].mi_Flags & ~CHECKED;
	    fi;
	fi;
    incase 1:
	/* Log File */
	if Logging then
	    Logging := false;
	    logOff();
	    ProjectItems[0].mi_Flags := ProjectItems[0].mi_Flags & ~CHECKED;
	fi;
	if fileRequest(ft_log) then
	    if logOn(&LogDir[0], &LogFileName[0]) then
		Logging := true;
		ProjectItems[0].mi_Flags := ProjectItems[0].mi_Flags | CHECKED;
	    fi;
	fi;
    incase 2:
	/* Mode */
	case SUBNUM(which)
	incase 0:
	    /* Both */
	    logMode(false);
	incase 1:
	    /* Input */
	    logMode(true);
	esac;
    incase 3:
	/* Source */
	doSource();
    incase 4:
	/* Snapshot */
	case SUBNUM(which)
	incase 0:
	    /* Text */
	    if fileRequest(ft_snap) then
		tx_snapshot(&SnapDir[0], &SnapFileName[0]);
	    fi;
	incase 1:
	    /* Graphics */
	    doGraphicsSnap();
	esac;
    incase 5:
	/* Quit */
	wantContinue := false;
/*
	ClearMenuStrip(TextWindow);
*/
    incase 6:
	/* Abort */
	if AutoRequest(TextWindow, &AbortBodyText, &AbortYesText,
		       &AbortNoText, 0x0, 0x0, 350, 52)
	then
	    doExit();
	fi;
    esac;
    wantContinue
corp;

/*
 * togglePicture - toggle the graphics picture on or off.
 */

proc togglePicture()void:

    if PictureShown then
	doHidePictureFixMenu();
    else
	doShowPictureFixMenu();
    fi;
corp;

/*
 * toggleGraphics - do processing of graphics toggle on/off.
 */

proc toggleGraphics()void:

    if GraphicsOn then
	GraphicsOn := false;
	ModesItems[4].mi_Flags := ModesItems[4].mi_Flags & ~CHECKED;
	if not TerminalMode then
	    gFlip(false);
	fi;
    else
	GraphicsOn := true;
	ModesItems[4].mi_Flags := ModesItems[4].mi_Flags | CHECKED;
	if not TerminalMode then
	    gFlip(true);
	fi;
    fi;
corp;

/*
 * toggleSound - do processing of sound toggle on/off.
 */

proc toggleSound()void:

    if SoundOn then
	SoundOn := false;
	ModesItems[5].mi_Flags := ModesItems[5].mi_Flags & ~CHECKED;
	if not TerminalMode then
	    sFlip(false);
	fi;
    else
	SoundOn := true;
	ModesItems[5].mi_Flags := ModesItems[5].mi_Flags | CHECKED;
	if not TerminalMode then
	    sFlip(true);
	fi;
    fi;
corp;

/*
 * toggleMusic - do processing of music toggle on/off.
 */

proc toggleMusic()void:

    if MusicOn then
	MusicOn := false;
	ModesItems[6].mi_Flags := ModesItems[6].mi_Flags & ~CHECKED;
	if not TerminalMode then
	    mFlip(false);
	fi;
    else
	MusicOn := true;
	ModesItems[6].mi_Flags := ModesItems[6].mi_Flags | CHECKED;
	if not TerminalMode then
	    mFlip(true);
	fi;
    fi;
corp;

/*
 * toggleVoice - do processing of voice toggle on/off.
 */

proc toggleVoice()void:

    if VoiceOn then
	voiceOff();
    else
	VoiceOn := true;
	ModesItems[7].mi_Flags := ModesItems[7].mi_Flags | CHECKED;
	if not TerminalMode then
	    vFlip(true);
	fi;
    fi;
corp;

/*
 * toggleEditWindow - do processing of show/hide the edit window.
 */

proc toggleEditWindow()void:

    if Editing then
	ModesItems[8].mi_Flags := ModesItems[8].mi_Flags & ~CHECKED;
	ed_hide();
    else
	ModesItems[8].mi_Flags := ModesItems[8].mi_Flags | CHECKED;
	ed_show();
    fi;
corp;

/*
 * doModesMenu - part of doMenuPick.
 */

proc doModesMenu(register uint which)void:

    case ITEMNUM(which)
    incase 0:
	/* History */
	case SUBNUM(which)
	incase 0:
	    /* Full */
	    tx_setHistoryType(ht_full);
	incase 1:
	    /* New */
	    tx_setHistoryType(ht_new);
	incase 2:
	    /* Minimal */
	    tx_setHistoryType(ht_minimal);
	esac;
    incase 1:
	/* Scroll On */
	case SUBNUM(which)
	incase 0:
	    /* Input */
	    tx_setScrollType(st_input);
	incase 1:
	    /* Output */
	    tx_setScrollType(st_output);
	incase 2:
	    /* Either */
	    tx_setScrollType(st_either);
	incase 3:
	    /* Neither */
	    tx_setScrollType(st_neither);
	esac;
    incase 2:
	/* Editor */
	case SUBNUM(which)
	incase 0:
	    /* Internal */
	    EditorChoice := ed_internal;
	incase 1:
	    /* Selected */
	    EditorChoice := ed_selected;
	incase 2:
	    /* External */
	    EditorChoice := ed_external;
	esac;
    incase 3:
	/* Picture */
	togglePicture();
    incase 4:
	/* Graphics */
	toggleGraphics();
    incase 5:
	/* Sound */
	toggleSound();
    incase 6:
	/* Music */
	toggleMusic();
    incase 7:
	/* Voice */
	toggleVoice();
    incase 8:
	/* Edit Win */
	if EditActive then
	    toggleEditWindow();
	fi;
    esac;
corp;

/*
 * doOptionsMenu - part of doMenuPick.
 */

proc doOptionsMenu(register uint which)void:

    case ITEMNUM(which)
    incase 0:
	/* ScreenToBack */
	screenToBack();
    incase 1:
	/* Workbench */
	if WorkBenchOn then
	    if CloseWorkBench() then
		WorkBenchOn := false;
		OptionsItems[1].mi_Flags := OptionsItems[1].mi_Flags&~CHECKED;
	    else
		OptionsItems[1].mi_Flags := OptionsItems[1].mi_Flags | CHECKED;
	    fi;
	else
	    if OpenWorkBench() ~= nil then
		WorkBenchOn := true;
	    else
		OptionsItems[1].mi_Flags := OptionsItems[1].mi_Flags&~CHECKED;
	    fi;
	fi;
    incase 2:
	/* Effects */
	case SUBNUM(which)
	incase 0: /* Free File */
	    ignore freeOneCachedFile();
	incase 1: /* Free Effect */
	    freeOneCachedEffect();
	incase 2: /* Zap Effects */
	    sendReleaseEffect(0);
	incase 3: /* Show Caches */
	    dumpEffectsCaches();
	incase 4: /* Quiet */
	    if EffectsQuiet then
		EffectsItem[4].mi_Flags := EffectsItem[4].mi_Flags & ~CHECKED;
		EffectsQuiet := false;
	    else
		EffectsItem[4].mi_Flags := EffectsItem[4].mi_Flags | CHECKED;
		EffectsQuiet := true;
	    fi;
	esac;
    incase 3:
	/* Memory */
	putString("Chip: avail: ");
	putUnsigned(AvailMem(MEMF_CHIP));
	putString(" largest: ");
	putUnsigned(AvailMem(MEMF_CHIP | MEMF_LARGEST));
	newLine();
	putString("Total: avail: ");
	putUnsigned(AvailMem(0x0));
	putString(" largest: ");
	putUnsigned(AvailMem(MEMF_LARGEST));
	newLine();
    esac;
corp;

/*
 * doSerialMenu - part of doMenuPick.
 */

proc doSerialMenu(register uint which)void:

    case ITEMNUM(which)
    incase 0:
	/* IgnoreCD */
	if SerialIgnoreCD then
	    SerialIgnoreCD := false;
	    SerialItems[0].mi_Flags := SerialItems[0].mi_Flags & ~CHECKED;
	else
	    SerialIgnoreCD := true;
	    SerialItems[0].mi_Flags := SerialItems[0].mi_Flags | CHECKED;
	fi;
    incase 1:
	/* Speed */
	BaudItem[0].mi_Flags := BaudItem[0].mi_Flags & ~CHECKED;
	BaudItem[1].mi_Flags := BaudItem[1].mi_Flags & ~CHECKED;
	BaudItem[2].mi_Flags := BaudItem[2].mi_Flags & ~CHECKED;
	BaudItem[3].mi_Flags := BaudItem[3].mi_Flags & ~CHECKED;
	BaudItem[4].mi_Flags := BaudItem[4].mi_Flags & ~CHECKED;
	BaudItem[5].mi_Flags := BaudItem[5].mi_Flags & ~CHECKED;
	BaudItem[6].mi_Flags := BaudItem[6].mi_Flags & ~CHECKED;
	case SUBNUM(which)
	incase 0:
	    /* 1200 */
	    SerialBaud := 1200;
	    BaudItem[0].mi_Flags := BaudItem[0].mi_Flags | CHECKED;
	incase 1:
	    /* 2400 */
	    SerialBaud := 2400;
	    BaudItem[1].mi_Flags := BaudItem[1].mi_Flags | CHECKED;
	incase 2:
	    /* 9600 */
	    SerialBaud := 9600;
	    BaudItem[2].mi_Flags := BaudItem[2].mi_Flags | CHECKED;
	incase 3:
	    /* 19200 */
	    SerialBaud := 19200;
	    BaudItem[3].mi_Flags := BaudItem[3].mi_Flags | CHECKED;
	incase 4:
	    /* 38400 */
	    SerialBaud := 38400;
	    BaudItem[4].mi_Flags := BaudItem[4].mi_Flags | CHECKED;
	incase 5:
	    /* 57600 */
	    SerialBaud := 57600;
	    BaudItem[5].mi_Flags := BaudItem[5].mi_Flags | CHECKED;
	incase 6:
	    /* 115200 */
	    SerialBaud := 115200;
	    BaudItem[6].mi_Flags := BaudItem[6].mi_Flags | CHECKED;
	esac;
	serialReconfig();
    incase 2:
	/* Break */
	serialSendBreak();
    incase 3:
	/* Connect */
	if TerminalMode then
	    serialForceConnect();
	fi;
    incase 4:
	/* Stats */
	serialStats();
    esac;
corp;

/*
 * doMenuPick - handle a MENUPICK event.
 */

proc doMenuPick(register uint which)bool:
    register *MenuItem_t mi;
    bool wantContinue;

    wantContinue := true;
    while which ~= MENUNULL do
	mi := ItemAddress(MainMenu, which);
	case MENUNUM(which)
	incase 0:
	    /* Project */
	    if not doProjectMenu(which) then
		wantContinue := false;
	    fi;
	incase 1:
	    /* Modes */
	    doModesMenu(which);
	incase 2:
	    /* Options */
	    doOptionsMenu(which);
	incase 3:
	    /* Serial */
	    doSerialMenu(which);
	esac;
	which := mi*.mi_NextSelect;
    od;
    wantContinue
corp;

/*
 * doNewSize - handle the NEWSIZE IDCMP event.
 */

proc doNewSize()void:
    register *RastPort_t rp;
    uint oldRows, oldCols, newRows, newCols;
    PLANEPTR newTempPlane;
    register bool onWorkbench;

    onWorkbench := Mode = md_oneWindow or Mode = md_twoWindow;
    if onWorkbench then
	/* User has resized window. */
	oldRows := DisplayRows;
	oldCols := DisplayCols;
	newRows := TextWindow*.w_Height;
	newCols := TextWindow*.w_Width;
	if Mode = md_twoWindow then
	    newTempPlane := GraphicsTempPlane;
	else
	    newTempPlane := AllocRaster(newCols, newRows);
	fi;
	if newTempPlane ~= nil then
	    if Mode = md_oneWindow then
		FreeRaster(GraphicsTempPlane, oldCols, oldRows);
		GraphicsTempPlane := newTempPlane;
		InitTmpRas(&GraphicsTmpRas, newTempPlane,
			   RASSIZE(newCols, newRows));
	    fi;
	    DisplayRows := newRows;
	    DisplayCols := newCols;
	    ignore figureText();
	    rp := TextRastPort;
	    if newCols < oldCols and newCols - RightBorder - 1 ~= RightEdge
	    then
		/* Zap out the partial characters of the partial column. */
		SetAPen(rp, ErasePen);
		RectFill(rp, RightEdge + 1,
			 TopBorder + GraphicsHeight + WORKBENCH_SEP,
			 newCols - RightBorder - 1,
			 newRows - BottomBorder - 1);
	    fi;
	    if newRows < oldRows and
		newRows - BottomBorder - 1 ~= TextHalfInputBottom
	    then
		/* Zap out the partial row of characters at the bottom. */
		SetAPen(rp, ErasePen);
		RectFill(rp, LeftBorder, TextHalfInputBottom + 1,
			 RightEdge, newRows - BottomBorder - 1);
	    fi;
	    /* This happens to do just what we need. */
	    ed_init();
	    tx_reInit();
	    if Mode = md_oneWindow then
		drawSeparator();
	    fi;
	    sendResize(TextHalfLines, TextColumns);
	else
	    errorString("Cannot resize - out of memory!\n");
	fi;
    fi;
    if Editing then
	ed_redraw();
    else
	tx_redraw(false);
    fi;
    if EditToggle or onWorkbench then
	/* Skip the contents of the next refresh event - the above call
	   has already done all we need. Shown true for md_twoScreen
	   and re-entering edit. See comment in 'ed_redraw'. */
	EditToggle := false;
	SkipRefresh := true;
    fi;
corp;

/*
 * handleFKey - handle a function key hit within our range.
 */

proc handleFKey(uint which)void:

    case which
    incase KEY_FUNC + 1:
	if Mode = md_oneScreen or Mode = md_twoScreen and not Editing then
	    togglePicture();
	fi;
    incase KEY_FUNC + 2:
	toggleGraphics();
    incase KEY_FUNC + 3:
	toggleSound();
    incase KEY_FUNC + 4:
	toggleMusic();
    incase KEY_FUNC + 5:
	toggleVoice();
    incase KEY_FUNC + 6:
	if EditActive then
	    EditToggle := true;
	    toggleEditWindow();
	fi;
    incase KEY_FUNC + 7:
	if Logging then
	    logOff();
	    Logging := false;
	    ProjectItems[0].mi_Flags := ProjectItems[0].mi_Flags & ~CHECKED;
	else
	    if LogFileName[0] ~= '\e' or fileRequest(ft_log) then
		if logOn(&LogDir[0], &LogFileName[0]) then
		    Logging := true;
		    ProjectItems[0].mi_Flags :=
			ProjectItems[0].mi_Flags | CHECKED;
		fi;
	    fi;
	fi;
    esac;
corp;

/*
 * handleRawKey - do RawKeyConvert stuff.
 */

proc handleRawKey(register *IntuiMessage_t im; bool wantInput)void:
    InputEvent_t ie;
    register int count, i;
    register char ch;

    if SourceFd = 0 then
	/* push it through RawKeyConvert */
	ie.ie_TimeStamp.tv_secs := im*.im_Seconds;
	ie.ie_TimeStamp.tv_micro := im*.im_Micros;
	ie.ie_NextEvent := nil;
	ie.ie_Class := IECLASS_RAWKEY;
	ie.ie_SubClass := 0;
	ie.ie_Code := im*.im_Code;
	ie.ie_Qualifier := im*.im_Qualifier;
	ie.ie_position.ie_addr := pretend(im*.im_IAddress, **byte)*;
	count := RawKeyConvert(&ie, &RawBuffer[0], RAW_MAX, nil);
	/* now can do the reply of the IntuiMessage */
	ReplyMsg(&im*.im_ExecMessage);
	if count > 0 then
	    for i from 0 upto count - 1 do
		ch := RawBuffer[i];
		if TerminalMode then
		    serialPutChar(ch);
		elif Editing then
		    ed_cookChar(ch);
		else
		    tx_cookChar(ch, wantInput);
		fi;
	    od;
	fi;
    else
	/* ignore normal keys while sourcing */
	ReplyMsg(&im*.im_ExecMessage);
    fi;
corp;

/*
 * doRawKey - initial handling of a RAWKEY event.
 */

proc doRawKey(register *IntuiMessage_t im; bool wantInput)bool:
    register uint which, qual;
    bool wantContinue;

    wantContinue := true;
    which := im*.im_Code;
    qual := im*.im_Qualifier;
    if qual & IEQUALIFIER_RCOMMAND ~= 0 then
	/* right-Amiga held - fake the menu shortcuts */
	ReplyMsg(&im*.im_ExecMessage);
	if which & IECODE_UP_PREFIX = 0 then
	    case which
	    incase 0x10:    /* q */
		wantContinue := false;
/*
		ClearMenuStrip(TextWindow);
*/
	    incase 0x35:    /* b */
		HadRAB := true;
		screenToBack();
	    incase 0x39:    /* . */
		if TerminalMode then
		    serialSendBreak();
		fi;
	    incase 0x33:    /* c */
		if TerminalMode then
		    serialForceConnect();
		fi;
	    incase 0x21:    /* s */
		if UsingSerial then
		    serialStats();
		fi;
		if HadRAB then
		    putProtStr1();
		fi;
	    incase 0x31:    /* z */
		sendReleaseEffect(0);
	    esac;
	fi;
    elif qual & (IEQUALIFIER_LALT | IEQUALIFIER_RALT) ~= 0 then
	/* An ALT key held. Doing this test before the one for
	   KeyMapTable allows us to handle the various ALT-keypad
	   keys. */
	if which = 0x4c or which = 0x4d then
	    /* an up or down arrow - handle scrolling */
	    ReplyMsg(&im*.im_ExecMessage);
	    if qual & (IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT) ~= 0 then
		case which
		incase 0x4c:	/* up arrow */
		    if Editing then
			ed_scrollLines(true, true);
		    else
			tx_scrollLines(true, true);
		    fi;
		incase 0x4d:	/* down arrow */
		    if Editing then
			ed_scrollLines(false, true);
		    else
			tx_scrollLines(false, true);
		    fi;
		esac;
	    else
		case which
		incase 0x4c:	/* up arrow */
		    if Editing then
			ed_scrollLines(true, false);
		    else
			tx_scrollLines(true, false);
		    fi;
		incase 0x4d:	/* down arrow */
		    if Editing then
			ed_scrollLines(false, false);
		    else
			tx_scrollLines(false, false);
		    fi;
		esac;
	    fi;
	else
	    handleRawKey(im, wantInput);
	fi;
    elif TerminalMode or KeyMapTable[which & 0x7f] = 0 or
	qual & (IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT) ~= 0 and
	    (which >= 0x3d and which <= 0x3f or
	     which >= 0x2d and which <= 0x2f or
	     which >= 0x1d and which <= 0x1f)
    then
	/* IECODE_UP_PREFIX is irrelevant, since 'RawKeyConvert' ignores
	   characters with it set. We need to let the shifted keypad
	   keys go through, since they are special for some European
	   Amigas (A1000). */
	handleRawKey(im, wantInput);
    elif which & IECODE_UP_PREFIX = 0 then
	ReplyMsg(&im*.im_ExecMessage);
	which := KeyMapTable[which];
	if qual & (IEQUALIFIER_LSHIFT | IEQUALIFIER_RSHIFT) ~= 0 then
	    which := which | KEY_SHIFT;
	fi;
	if which >= KEY_FUNC + 1 and which <= KEY_FUNC + 10 then
	    handleFKey(which);
	else
	    if not TerminalMode then
		if Editing then
		    ed_specialKey(which);
		else
		    tx_specialKey(which);
		fi;
	    fi;
	fi;
    else
	/* ignore the key-up ones */
	ReplyMsg(&im*.im_ExecMessage);
    fi;
    wantContinue
corp;

/*
 * doScroll - call the appropriate scroll routine.
 */

proc doScroll()void:

    if Editing then
	ed_scroll();
    else
	tx_scroll();
    fi;
corp;

/*
 * doBorderFixup - do fixups of borders needed on ACTIVEWINDOW/INACTIVEWINDOW.
 */

proc doBorderFixup()void:

    if OldStyle then
	if PictureShown and not Editing then
	    SetAPen(TextRastPort, ERASE_PEN);
	    RectFill(TextRastPort, 0,
		TextHalfLines * CHAR_HEIGHT + OLD_TOP_BORDER + OLD_BORDER,
		TextWidth - 1, TextFullHeight - OLD_BOTTOM_BORDER - 1);
	    SetAPen(TextRastPort, CST_TEXT_PEN);
	fi;
	tx_drawBorders(0);
    fi;
corp;

/*
 * checkRefresh - do a refresh if we might need one.
 */

proc checkRefresh()void:

    if WantRefresh then
	if TextRastPort*.rp_Layer ~= nil and
	    TextRastPort*.rp_Layer*.l_Flags & LAYERREFRESH ~= 0
	then
	    handleRefresh();
	fi;
	WantRefresh := false;
    fi;
corp;

/*
 * handleMessage - handle a regular IntuiMessage_t.
 *	Return 'false' if we want to exit.
 */

proc handleMessage(register *IntuiMessage_t im; bool wantInput)bool:
    register ulong class;
    register uint which;
    int count, mouseX, mouseY;
    bool wantContinue;

    class := im*.im_Class;
    which := im*.im_Code;
    mouseX := im*.im_MouseX;
    mouseY := im*.im_MouseY;
    /* Do not reply to the messages we are going to pass to 'RawKeyConvert'
       yet, since we need the magic pointer a bit longer in that case. */
    if class ~= RAWKEY then
	ReplyMsg(&im*.im_ExecMessage);
	HadRAB := false;
    fi;
    wantContinue := true;
    if class ~= REFRESHWINDOW and class ~= NEWSIZE then
	SkipRefresh := false;
    fi;
    case class
    incase CLOSEWINDOW:
	if Editing then
	    /* Make the close box during editing be the same as ^C */
	    ed_cookChar(0x03 + '\e');
	else
	    wantContinue := false;
/*
	    ClearMenuStrip(TextWindow);
*/
	fi;
    incase NEWSIZE:
	doNewSize();
    incase MENUPICK:
	wantContinue := doMenuPick(which);
    incase RAWKEY:
	wantContinue := doRawKey(im, wantInput);
    incase GADGETDOWN:
	Scrolling := true;
	doScroll();
    incase GADGETUP:
	Scrolling := false;
	doScroll();
    incase MOUSEMOVE:
	if Scrolling then
	    doScroll();
	else
	    /* must be a graphics window button-down movement */
	    mouseCheck(mouseX, mouseY, mc_move);
	fi;
    incase MOUSEBUTTONS:
	if not TerminalMode then
	    if which = (IECODE_LBUTTON | IECODE_UP_PREFIX) then
		/* left mouse button up */
		mouseCheck(mouseX, mouseY, mc_up);
		ReportMouse(0,
		    if Mode = md_oneWindow then
			TextWindow
		    else
			GraphicsWindow
		    fi);
	    elif which = IECODE_LBUTTON then
		/* left mouse button down */
		mouseCheck(mouseX, mouseY, mc_down);
		ReportMouse(-1,
		    if Mode = md_oneWindow then
			TextWindow
		    else
			GraphicsWindow
		    fi);
	    fi;
	fi;
    incase ACTIVEWINDOW:
	doBorderFixup();
    incase INACTIVEWINDOW:
	doBorderFixup();
    incase REFRESHWINDOW:
	/* These events can come for system requesters, and anything
	   else that makes it onto my window. */
	if SkipRefresh then
	    BeginRefresh(TextWindow);
	    EndRefresh(TextWindow, -1);
	    SkipRefresh := false;
	else
	    handleRefresh();
	    WantRefresh := false;
	fi;
    esac;
    checkRefresh();
    wantContinue
corp;
