#drinc:graphics/gfx.g
#drinc:graphics/rastport.g

#graphics.g
#funcs.g
#globals.g

type
    RGB_t = struct {
	ushort rgb_r, rgb_g, rgb_b;
    };

proc iffGetClass(register uint colour)ushort:
    register uint r @ colour, g, b;
    register ushort class;

    b := colour & 0xf;
    colour := colour >> 4;
    g := colour & 0xf;
    colour := colour >> 4;
    /* r := colour; */

    if r < 4 and g < 4 and b < 4 then
	0
    else
	if r >= g then
	    if r >= b then
		class := 0x4;
		if r - g < r / 2 then
		    class := class | 0x2;
		fi;
		if r - b < r / 2 then
		    class := class | 0x1;
		fi;
	    else
		class := 0x1;
		if b - g < b / 2 then
		    class := class | 0x2;
		fi;
		if b - r < b / 2 then
		    class := class | 0x4;
		fi;
	    fi;
	else
	    if g >= b then
		class := 0x2;
		if g - b < g / 2 then
		    class := class | 0x1;
		fi;
		if g - r < g / 2 then
		    class := class | 0x4;
		fi;
	    else
		class := 0x1;
		if b - g < b / 2 then
		    class := class | 0x2;
		fi;
		if b - r < b / 2 then
		    class := class | 0x4;
		fi;
	    fi;
	fi;
	class
    fi
corp;

proc iffSetClass(register *ushort pClass; register *uint pMap; uint count)void:
    register uint i, colour;

    for i from 0 upto count - 1 do
	colour := pMap*;
	pMap := pMap + sizeof(uint);
	pClass* := iffGetClass(colour);
	pClass := pClass + sizeof(ushort);
    od;
corp;

proc iffExtractRGB(register *RGB_t pRGB; register *uint pMap; uint count)void:
    register uint i, colour;
    register ushort r @ colour, g, b;

    for i from 0 upto count - 1 do
	colour := pMap*;
	pMap := pMap + sizeof(uint);
	b := colour;
	b := b & 0xf;
	colour := colour >> 4;
	g := colour;
	g := g & 0xf;
	colour := colour >> 4;
	/* r := colour; */
	pRGB*.rgb_r := r;
	pRGB*.rgb_g := g;
	pRGB*.rgb_b := b;
	pRGB := pRGB + sizeof(RGB_t);
    od;
corp;

proc iffFindClosest(register uint colour; ushort class; register *RGB_t pRGB;
		    register *ushort pClass; uint count)uint:
    register short diff;
    register int total;
    register ushort r @ colour, b, g;
    register int minTotal;
    register uint minIndex, i;

    b := colour & 0xf;
    colour := colour >> 4;
    g := colour & 0xf;
    colour := colour >> 4;
    /* r := colour; */
    minIndex := count;
    minTotal := 1000;
    for i from 0 upto count - 1 do
	if pClass* = class then
	    diff := pRGB*.rgb_r - r;
	    if diff < 0 then
		diff := -diff;
	    fi;
	    total := diff * diff;
	    diff := pRGB*.rgb_g - g;
	    if diff < 0 then
		diff := -diff;
	    fi;
	    total := total + diff * diff;
	    diff := pRGB*.rgb_b - b;
	    if diff < 0 then
		diff := -diff;
	    fi;
	    total := total + diff * diff;
	    if total < minTotal then
		minTotal := total;
		minIndex := i;
	    fi;
	fi;
	pRGB := pRGB + sizeof(RGB_t);
	pClass := pClass + sizeof(ushort);
    od;
    minIndex
corp;

proc iffFindBest(uint colour; register *RGB_t pRGB;
		 register *ushort pClass; register uint count)uint:
    register ushort class;
    register uint minIndex;

    class := iffGetClass(colour);
    minIndex := iffFindClosest(colour, class, pRGB, pClass, count);
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x4, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x2, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x1, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x6, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x3, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x5, pRGB, pClass, count);
    fi;
    if minIndex = count then
	minIndex := iffFindClosest(colour, class >< 0x7, pRGB, pClass, count);
    fi;
    if minIndex = count then
	errorString("Cannot find any matching colour!\n");
	doExit();
    fi;
    minIndex
corp;

proc iffMapColour(uint colour)uint:
    [MAX_COLOURS] uint colourMap;
    [MAX_COLOURS] ushort toClass;
    [MAX_COLOURS] RGB_t toRGB;

    getColourMap(&colourMap[0], false);
    iffSetClass(&toClass[0], &colourMap[0], ColourCount);
    iffExtractRGB(&toRGB[0], &colourMap[0], ColourCount);
    iffFindBest(colour, &toRGB[0], &toClass[0], ColourCount)
corp;

proc iffCreateMapping(register *uint mapping;
		      uint fromCount; register *uint fromMap;
		      register uint toCount; *uint toMap)void:
    [MAX_COLOURS] ushort toClass;
    [MAX_COLOURS] RGB_t toRGB;
    register uint i;

    iffSetClass(&toClass[0], toMap, toCount);
    iffExtractRGB(&toRGB[0], toMap, toCount);
    for i from 0 upto fromCount - 1 do
	mapping* := iffFindBest(fromMap*, &toRGB[0], &toClass[0], toCount);
	mapping := mapping + sizeof(uint);
	fromMap := fromMap + sizeof(uint);
    od;
corp;

proc iffPerformMapping(*uint mapping; *BitMap_t toBitMap, fromBitMap;
		       uint width, height)void:
    RastPort_t toRastPort, fromRastPort;
    register *RastPort_t toRp, fromRp;
    register uint x, y;

    toRp := &toRastPort;
    InitRastPort(toRp);
    toRp*.rp_BitMap := toBitMap;
    fromRp := &fromRastPort;
    InitRastPort(fromRp);
    fromRp*.rp_BitMap := fromBitMap;
    for y from 0 upto height - 1 do
	for x from 0 upto width - 1 do
	    SetAPen(toRp, (mapping + ReadPixel(fromRp, x, y) * sizeof(uint))*);
	    ignore WritePixel(toRp, x, y);
	od;
    od;
corp;

proc iffClipPens(*BitMap_t bm; uint width, height)void:
    RastPort_t rastPort;
    register *RastPort_t rp;
    register uint x, y;

    rp := &rastPort;
    InitRastPort(rp);
    rp*.rp_BitMap := bm;
    for y from 0 upto height - 1 do
	for x from 0 upto width - 1 do
	    SetAPen(rp, ReadPixel(rp, x, y) % ColourCount);
	    ignore WritePixel(rp, x, y);
	od;
    od;
corp;
