/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * funcs.g - functions shared amongst source files of the MUD client program.
 */


type
    PictureType_t = enum {
	pt_backGround,		/* use its palette */
	pt_image,		/* nothing special */
	pt_brush		/* allow a mask plane */
    },

    MouseCheck_t = enum {
	mc_down,		/* left button pressed */
	mc_up,			/* button released */
	mc_move 		/* moving while button down */
    };

extern
    /* main.d */

    errorChar(char ch)void,
    errorString(*char message)void,
    errorNum(long n)void,
    errorHex(ulong n)void,
    complain1(*char m)void,
    complain3(*char m1, m2, m3)void,
    myAllocRequest(uint len)*Request_t,
    myFreeRequest(*Request_t rq)void,
    doExit()void,
    doMUDSource(*char fileName)bool,
    mudAlloc(ulong length, flags)arbptr,
    noMemory(*char what)void,
    editNextError(bool skipRest)void,
    editEnd(bool aborted)void,
    editCook(*char buf; uint len, maxColumn;
	     proc(*char buf; uint len)bool cooker)bool,
    sendLine(*char p; uint len)void,
    setSync(bool flag)void,
    sendKey(uint key)void,
    sendRegion(uint n, mouseX, mouseY)void,
    sendButton(uint whichButton)void,
    sendReleaseEffect(ulong key)void,
    sendResize(uint newRows, newCols)void,
    checkMessages()void,
    gFlip(bool onOff)void,
    vFlip(bool onOff)void,
    sFlip(bool onOff)void,
    mFlip(bool onOff)void,
    eDone(ulong kind, id)void,
    addEffectsBit(ulong bit)void,

    /* Intuition.d */

    zapArea()void,
    getColourMap(*uint map; bool wantDefault)void,
    intuitionInit(bool usingSerial, closeWorkbench, bright, _dim)bool,
    intuitionTerm()void,
    setTerminalMode()void,
    clearTerminalMode()void,
    removeMenus()void,
    screenToBack()void,
    screenToFront()void,
    voiceOff()void,
    handleMessage(*IntuiMessage_t im; bool wantInput)bool,
    getEffects(*EffectsInfo_t ei)void,
    getString(*char prompt, initial; **char pRes)bool,
    setGraphicsPen(uint pen, colour)void,
    setGraphicsPalette(*uint palette; uint colourCount)void,
    resetColours()void,
    setGraphicsAPen(uint pen)void,
    setGraphicsBPen(uint pen)void,
    setGraphicsRast(uint pen)void,
    setTextPen(uint which, colour)void,
    checkRefresh()void,

    /* text.d */

    newLine()void,
    putChar(char ch)void,
    putString(*char p)void,
    putText(*char p; uint len)void,
    putUnsigned(ulong n)void,
    setEcho(bool wantOn)void,
    setPrompt(*char pr)void,
    forceChars(*char buffer; ulong len)void,

    /* edit.d */

    ed_freeBuffer()void,
    ed_errorStart(uint column)void,
    ed_errorString(*char st)void,
    ed_start()void,
    ed_text(*char p; uint len)bool,
    ed_stringText(*char p; uint len)bool,
    ed_go(*char prompt)void,
    ed_getLine(*char buff; uint maxLen; *uint pGotLen)bool,
    ed_setIsRaw(bool isRaw)void,
    ed_normalize(*char buf; uint bLen; bool first; *char allocBuf;
		 uint allocLen; *uint pExtraLen, pColumn)uint,
    ed_getString(**char pBuff; *uint pLen, pAllocLen)void,

    /* effects.d */

    effectsInit()bool,
    freeString(*char st)void,
    freeOneCachedFile()bool,
    flushCachedImages()void,
    effectsTerm(bool partial)void,
    mouseCheck(int mouseX, mouseY; MouseCheck_t mc)void,
    unHighLightButton()void,
    doEffects(*byte buf; uint len)void,
    defineEffect(ulong key; *byte data; uint len)void,
    flushEffect(ulong key)void,
    freeOneCachedEffect()void,
    dumpEffectsCaches()void,
    handleEffectSignal(ulong bits)void,
    displayIntro()void,

    /* iff.d */

    freeBitMap(*BitMap_t bm; uint w, h)void,
    allocBitMap(*BitMap_t bm; uint d, w, h; *char desc)bool,
    iffLoadILBM(*char filePath; PictureType_t pt)arbptr,
    iffFreeILBM(arbptr im)void,
    iffLoadBackGround(arbptr il)void,
    showBitMap(*BitMap_t bm; uint imageX, imageY, imageWidth, imageHeight,
	       fullWidth, fullHeight; int displayX, displayY)void,
    iffShowBitMap(arbptr il; uint imageX, imageY, imageWidth, imageHeight;
		  int displayX, displayY)void,
    iffShowImagePixels(arbptr im; uint imageX, imageY, imageWidth, imageHeight;
		       int displayX, displayY)void,
    iffShowImage(arbptr im; long imageX, imageY, imageWidth, imageHeight,
		 displayX, displayY, displayWidth, displayHeight)void,
    iffShowBrush(arbptr br; int displayX, displayY)void,
    iffLoad8SVX(*char filePath)arbptr,
    iffFree8SVX(arbptr sn)void,
    iffLoadSMUS(*char filePath)arbptr,
    iffFreeSMUS(arbptr mu)void,

    /* iffWrite.d */

    iffDumpILBM(*char filePath; *RastPort_t bm; *uint colourTable;
		bool stripHighPlane)void,

    /* serial.d */

    serialStats()void,
    openSerialHandler(*char device; ulong unit, retryLimit;
		      bool ready, shared, _7Wire)ulong,
    closeSerialHandler(*char device; ulong unit)void,
    serialSendMessage(*Request_t rq)void,
    serialGetMessage()*Request_t,
    handleSerialEvents(ulong bits)void,
    serialConversation(*MsgPort_t intuitionPort; *char dialString)bool,
    serialPutChar(char ch)void,
    serialReconfig()void,
    serialSendBreak()void,
    serialForceConnect()void;
