/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iff.g - definitions for this version of IFF support.
 */

uint IFF_BUFFER_SIZE = 512;
uint MAX_DEPTH = 8;				/* max supported by my code */

type
    Handle_t = unknown 4,

    IFFID_t = ulong,				/* use pretend for [4] char */

    IFFClient_t = struct {
	[IFF_BUFFER_SIZE] byte iff_data;	/* buffer of raw data */
	*char iff_fileName;			/* name of file */
	Handle_t iff_file;			/* file handle of input file */
	uint iff_position;			/* position in buffer */
	uint iff_remaining;			/* bytes left in buffer */
		/* dispatch table of routines to read chunks */
	proc(*IFFContext_t context; IFFID_t subId)bool
	     iff_readForm, iff_readList, iff_readCat, iff_readProp;
	proc(*IFFContext_t context; IFFID_t id)bool iff_readOther;
	arbptr iff_userStructure;		/* whatever you want */
    },

    IFFContext_t = struct {
	*IFFContext_t iff_parent;		/* pointer to parent */
	*IFFClient_t iff_client;		/* pointer to common client */
	ulong iff_totalRemaining;		/* total left in chunk */
	ulong iff_totalRead;			/* total read from chunk */
    },

    IFFHeader_t = struct {
	IFFID_t iff_id;
	ulong iff_chunkLength;
    },

    IFFHeader2_t = struct {
	IFFHeader_t iff_header;
	IFFID_t iff_subId;
    };

ulong
    ID_FORM = ('F' - '\e') << 24 | ('O' - '\e') << 16 |
	      ('R' - '\e') <<  8 | ('M' - '\e'),
    ID_LIST = ('L' - '\e') << 24 | ('I' - '\e') << 16 |
	      ('S' - '\e') <<  8 | ('T' - '\e'),
    ID_CAT  = ('C' - '\e') << 24 | ('A' - '\e') << 16 |
	      ('T' - '\e') <<  8 | (' ' - '\e'),
    ID_PROP = ('P' - '\e') << 24 | ('R' - '\e') << 16 |
	      ('O' - '\e') <<  8 | ('P' - '\e');

extern
    IFFErrorClient(*IFFClient_t client; *char m)void,
    IFFErrorContext(*IFFContext_t context; *char m)void,
    IFFReadFile(*char fileName; *IFFClient_t client)bool,
    IFFSkip(*IFFContext_t context; ulong amount)bool,
    IFFSkipChunk(*IFFContext_t context)bool,
    IFFRead(*IFFContext_t context; arbptr buffer; ulong length)bool,
    IFFReadGroupOpen(*IFFContext_t prev, next)void,
    IFFReadGroupClose(*IFFContext_t context)bool,
    IFFReadCatTail(*IFFContext_t parent)bool,
    IFFReadListTail(*IFFContext_t parent)bool,
    IFFReadFormTail(*IFFContext_t parent)bool,
    IFFReadPropTail(*IFFContext_t parent)bool,

    iffMapColour(uint colour)uint,
    iffClipPens(*BitMap_t bm; uint width, height)void,
    iffCreateMapping(*uint mapping; uint fromCount; *uint fromMap;
		     uint toCount; *uint toMap)void,
    iffPerformMapping(*uint mapping; *BitMap_t toBitMap, fromBitMap;
		      uint width, height)void;
