/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iff8SVX.g - definitions for IFF 8SVX.
 */

/* 'S' on everything for Sample */

ulong
    ID_S8SVX	  = ('8' - '\e') << 24 | ('S' - '\e') << 16 |
		    ('V' - '\e') <<  8 | ('X' - '\e'),
    ID_SVHDR	  = ('V' - '\e') << 24 | ('H' - '\e') << 16 |
		    ('D' - '\e') <<  8 | ('R' - '\e'),
    ID_SNAME	  = ('N' - '\e') << 24 | ('S' - '\e') << 16 |
		    ('M' - '\e') <<  8 | ('E' - '\e'),
    ID_SCopyright = ('(' - '\e') << 24 | ('c' - '\e') << 16 |
		    (')' - '\e') <<  8 | (' ' - '\e'),
    ID_SAUTH	  = ('A' - '\e') << 24 | ('U' - '\e') << 16 |
		    ('T' - '\e') <<  8 | ('H' - '\e'),
    ID_SANNO	  = ('A' - '\e') << 24 | ('N' - '\e') << 16 |
		    ('N' - '\e') <<  8 | ('O' - '\e'),
    ID_SBODY	  = ('B' - '\e') << 24 | ('O' - '\e') << 16 |
		    ('D' - '\e') <<  8 | ('Y' - '\e'),
    ID_SATAK	  = ('A' - '\e') << 24 | ('T' - '\e') << 16 |
		    ('A' - '\e') <<  8 | ('K' - '\e'),
    ID_SRLSE	  = ('R' - '\e') << 24 | ('L' - '\e') << 16 |
		    ('S' - '\e') <<  8 | ('E' - '\e');

type Fixed_t = ulong;

Fixed_t UNITY = 0x10000;

type
    SCompression_t = enum {
	scmp_none,			/* data not compressed */
	scmp_FibDelta			/* Fibonacci-delta compression */
    },

    Voice8Header_t = struct {
	ulong
	    v8h_oneShotHiSamples,	/* # samples in hi octave 1-shot */
	    v8h_repeatHiSamples,	/* # samples in hi octave repeat */
	    v8h_samplesPerHiCycle;	/* samples/cycle in hi oct., else 0 */
	uint v8h_samplesPerSecond;	/* data sampling rate */
	ushort v8h_ctOctave;		/* # of octaves of waveform */
	SCompression_t v8h_compression; /* compression technique */
	Fixed_t v8h_volume;		/* overall playback volume */
    },

    EGPoint_t = struct {
	uint egp_duration;		/* segment duration in millisec, or 0*/
	Fixed_t egp_dest;		/* destination volume factor */
    };

extern
    IFFReadSVHDR(*IFFContext_t context; *Voice8Header_t v8h)bool,
    IFFReadSBODY(*IFFContext_t context; *short buffer; *ulong pBuffLen;
		 *Voice8Header_t v8h)bool;
