#iff.g
#iff8SVX.g
#funcs.g

/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iff8SVXRead.d - code to read IFF 8SVXs.
 */

proc IFFReadSBODY(register *IFFContext_t context; register *short buffer;
		  *ulong pBuffLen; *Voice8Header_t v8h)bool:
    ulong BUFFER_SIZE = 512;
    [16] short DELTA = (-34,-21,-13,-8,-5,-3,-2,-1,0,1,2,3,5,8,13,21);
    [BUFFER_SIZE] byte localBuffer;
    register *byte p;
    register ulong actualLen, gotLen;
    register short sample;
    short tmp;
    register byte b;

    actualLen := pBuffLen*;
    if v8h*.v8h_compression > scmp_FibDelta then
	IFFErrorContext(context, "8SVX compression");
	false
    elif v8h*.v8h_compression = scmp_none then
	if context*.iff_totalRemaining < actualLen then
	    actualLen := context*.iff_totalRemaining;
	    pBuffLen* := actualLen;
	fi;
	if IFFRead(context, buffer, actualLen) then
	    if context*.iff_totalRemaining ~= 0 then
		if IFFSkip(context, context*.iff_totalRemaining) then
		    true
		else
		    IFFErrorContext(context, "8SVX BODY nocmp skip");
		    false
		fi
	    else
		true
	    fi
	else
	    IFFErrorContext(context, "8SVX BODY nocmp read");
	    false
	fi
    else
	/* Fibonacci-Delta compression - use localBuffer to decompress */
	if (context*.iff_totalRemaining - 1) * 2 < actualLen then
	    actualLen := (context*.iff_totalRemaining - 1) * 2;
	    pBuffLen* := actualLen;
	fi;
	if IFFRead(context, &tmp, 1) and IFFRead(context, &tmp, 1) then
	    sample := tmp;
	    while actualLen ~= 0 do
		gotLen :=
		    if context*.iff_totalRemaining < BUFFER_SIZE then
			context*.iff_totalRemaining
		    else
			BUFFER_SIZE
		    fi;
		if not IFFRead(context, &localBuffer[0], gotLen) then
		    actualLen := 0;
		else
		    p := &localBuffer[0];
		    while gotLen ~= 0 do
			gotLen := gotLen - 1;
			b := p*;
			p := p + sizeof(byte);
			sample := sample + DELTA[b >> 4];
			buffer* := sample;
			buffer := buffer + sizeof(short);
			actualLen := actualLen - 1;
			if actualLen ~= 0 then
			    sample := sample + DELTA[b & 0xf];
			    buffer* := sample;
			    buffer := buffer + sizeof(short);
			    actualLen := actualLen - 1;
			fi;
		    od;
		fi;
	    od;
	    if context*.iff_totalRemaining ~= 0 then
		if IFFSkip(context, context*.iff_totalRemaining) then
		    true
		else
		    IFFErrorContext(context, "8SVX BODY cmp skip");
		    false
		fi
	    else
		true
	    fi
	else
	    IFFErrorContext(context, "8SVX BODY cmp read");
	    false
	fi
    fi
corp;
