/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iffILBM.g - definitions for IFF ILBM.
 */

/* 'B' on everything for Bitmap */

ulong
    ID_BILBM = ('I' - '\e') << 24 | ('L' - '\e') << 16 |
	       ('B' - '\e') <<	8 | ('M' - '\e'),
    ID_BBMHD = ('B' - '\e') << 24 | ('M' - '\e') << 16 |
	       ('H' - '\e') <<	8 | ('D' - '\e'),
    ID_BCMAP = ('C' - '\e') << 24 | ('M' - '\e') << 16 |
	       ('A' - '\e') <<	8 | ('P' - '\e'),
    ID_BGRAB = ('G' - '\e') << 24 | ('R' - '\e') << 16 |
	       ('A' - '\e') <<	8 | ('B' - '\e'),
    ID_BDEST = ('D' - '\e') << 24 | ('E' - '\e') << 16 |
	       ('S' - '\e') <<	8 | ('T' - '\e'),
    ID_BSPRT = ('S' - '\e') << 24 | ('P' - '\e') << 16 |
	       ('R' - '\e') <<	8 | ('T' - '\e'),
    ID_BCAMG = ('C' - '\e') << 24 | ('A' - '\e') << 16 |
	       ('M' - '\e') <<	8 | ('G' - '\e'),
    ID_BCRNG = ('C' - '\e') << 24 | ('R' - '\e') << 16 |
	       ('N' - '\e') <<	8 | ('G' - '\e'),
    ID_BBODY = ('B' - '\e') << 24 | ('O' - '\e') << 16 |
	       ('D' - '\e') <<	8 | ('Y' - '\e');

type
    BMasking_t = enum {
	bmsk_none,
	bmsk_hasMask,
	bmsk_hasTransParentColour,
	bmsk_lasso
    },

    BCompression_t = enum {
	bcmp_none,
	bcmp_byteRun1
    },

    BitMapHeader_t = struct {
	uint bmh_w, bmh_h;			/* width, height */
	int bmh_x, bmh_y;			/* position? */
	ushort bmh_nPlanes;			/* depth */
	BMasking_t bmh_masking; 		/* mask plane present? */
	BCompression_t bmh_compression; 	/* compression scheme */
	byte pad1;				/* store 0 here */
	uint bmh_transparentColor;		/* transparent "color number"*/
	ushort bmh_xAspect, bmh_yAspect;	/* x/y aspect ratio */
	uint bmh_pageWidth, bmh_pageHeight;	/* source page in pixels */
    },

    ColorRegister_t = struct {
	byte cr_red, cr_green, cr_blue;
    },

    Point2D_t = struct {
	uint p2d_x, p2d_y;
    },

    DestMerge_t = struct {
	ushort dm_depth;			/* depth of original source */
	byte dm_pad1;				/* store a 0 here */
	uint dm_planePick;			/* how to scatter src to dst */
	uint dm_planeOnOff;			/* default values */
	uint dm_planeMask;			/* which should be touched */
    },

    SpritePrecedence_t = uint,

    ViewPortMode_t = ulong,

    CRange_t = struct {
	uint cr_pad1;				/* store a 0 here */
	uint cr_rate;				/* 16384 = 60 steps /second */
	uint cr_active; 			/* non-zero means on */
	ushort cr_low, cr_high; 		/* lower and upper registers */
    };

extern
    IFFReadBCMAP(*IFFContext_t context; **uint pColourMap;
		 *uint pColourCount)bool,
    IFFReadBBODY(*IFFContext_t context; *BitMap_t bitmap; *uint mask;
		 uint width, height; BCompression_t compression;
		 BMasking_t masking)bool,
    IFFMakeMaskPlane(*BitMap_t bm; *uint mask; uint width;
		     ushort transparentColour)void;
