#drinc:graphics/gfx.g
#drinc:graphics/rastport.g

#funcs.g
#iff.g
#iffILBM.g
#graphics.g

/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iffILBMRead.d - code to read IFF ILBMs.
 */

proc IFFReadBCMAP(register *IFFContext_t context; **uint pColourMap;
		  *uint pColourCount)bool:
    register *uint map;
    ColorRegister_t colorReg;
    register uint count;

    count := context*.iff_totalRemaining / sizeof(ColorRegister_t);
    if count < 2 then
	pColourMap* := nil;
	return(true);
    fi;

    if count * sizeof(ColorRegister_t) ~= context*.iff_totalRemaining then
	IFFErrorContext(context, "CMAP length");
	return(false);
    fi;
    map := mudAlloc(count * sizeof(uint), 0x0);
    if map = nil then
	noMemory("colourMap");
	return(false);
    fi;
    pColourMap* := map;
    pColourCount* := count;

    while count ~= 0 do
	count := count - 1;
	if not IFFRead(context, &colorReg, sizeof(ColorRegister_t)) then
	    IFFErrorContext(context, "ILBM CMAP read");
	    return(false);
	fi;
	map* :=
	    (make(colorReg.cr_red   >> 4, uint) << 8) |
	    (make(colorReg.cr_green >> 4, uint) << 4) |
	    (make(colorReg.cr_blue  >> 4, uint) << 0);
	map := map + sizeof(uint);
    od;
    true
corp;

proc IFFReadBBODY(register *IFFContext_t context; *BitMap_t bitMap; *uint mask;
		  uint width, height; BCompression_t compression;
		  BMasking_t masking)bool:
    [MAX_DEPTH + 1] *byte planes;
    register *byte p;
    register uint plane, i, n2, bytesPerRow;
    uint planeCount;
    byte b;
    register short n @ n2;
    short nPrime;

    bytesPerRow := (width + 15) / 16 * 2;
    if compression > bcmp_byteRun1 then
	IFFErrorContext(context, "ILBM BODY compression");
	return(false);
    fi;
    for i from bitMap*.bm_Depth - 1 downto 0 do
	planes[i] := pretend(bitMap*.bm_Planes[i], *byte);
    od;
    planeCount := bitMap*.bm_Depth;
    if masking = bmsk_hasMask then
	planes[planeCount] := pretend(mask, *byte);
	planeCount := planeCount + 1;
    fi;

    while height ~= 0 do
	height := height - 1;
	for plane from 0 upto planeCount - 1 do
	    p := planes[plane];
	    if compression = bcmp_none then
		if not IFFRead(context, p, bytesPerRow) then
		    IFFErrorContext(context, "ILBM BODY read");
		    return(false);
		fi;
		p := p + bytesPerRow;
	    else
		i := bytesPerRow;
		while i ~= 0 do
		    if not IFFRead(context, &nPrime, 1) then
			IFFErrorContext(context, "ILBM BODY read");
			return(false);
		    fi;
		    n := nPrime;
		    if n >= 0 then
			n2 := make(n, int) + 1;
			if n2 > i then
			    IFFErrorContext(context,"ILBM BODY cmp structure");
			    return(false);
			fi;
			i := i - n2;
			if not IFFRead(context, p, n2) then
			    IFFErrorContext(context, "ILBM BODY cmp read");
			    return(false);
			fi;
			p := p + n2;
		    elif n ~= -128 then
			n2 := -make(n, int) + 1;
			if n2 > i then
			    IFFErrorContext(context, "ILBM BODY cmp read");
			    return(false);
			fi;
			i := i - n2;
			if not IFFRead(context, &b, 1) then
			    IFFErrorContext(context, "ILBM BODY cmp read");
			    return false;
			fi;
			for n2 from n2 - 1 downto 0 do
			    p* := b;
			    p := p + 1;
			od;
		    fi;
		od;
	    fi;
	    planes[plane] := p;
	od;
    od;
    if not IFFSkipChunk(context) then
	IFFErrorContext(context, "ILBM skip");
	return(false);
    fi;
    true
corp;

proc IFFMakeMaskPlane(*BitMap_t bm; *uint mask; uint width;
		      ushort transparentColour)void:
    RastPort_t rp;
    register uint x, y, bits;

    width := (width + 0xf) & 0xfff0;
    InitRastPort(&rp);
    rp.rp_BitMap := bm;
    for y from 0 upto bm*.bm_Rows - 1 do
	bits := 0x0000;
	for x from 0 upto width - 1 do
	    bits := bits << 1;
	    if ReadPixel(&rp, x, y) ~= transparentColour then
		bits := bits | 0x0001;
	    fi;
	    if x & 0xf = 0xf then
		mask* := bits;
		mask := mask + sizeof(uint);
		bits := 0x0000;
	    fi;
	od;
	if width & 0xf ~= 0x0 then
	    mask* := bits;
	    mask := mask + sizeof(uint);
	fi;
    od;
corp;
