/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iffSMUS.g - definitions for IFF SMUS.
 */

/* 'M' on everything for Music */

ulong
    ID_MSMUS	  = ('S' - '\e') << 24 | ('M' - '\e') << 16 |
		    ('U' - '\e') <<  8 | ('S' - '\e'),
    ID_MSHDR	  = ('S' - '\e') << 24 | ('H' - '\e') << 16 |
		    ('D' - '\e') <<  8 | ('R' - '\e'),
    ID_MNAME	  = ('N' - '\e') << 24 | ('S' - '\e') << 16 |
		    ('M' - '\e') <<  8 | ('E' - '\e'),
    ID_MCopyright = ('(' - '\e') << 24 | ('c' - '\e') << 16 |
		    (')' - '\e') <<  8 | (' ' - '\e'),
    ID_MAUTH	  = ('A' - '\e') << 24 | ('U' - '\e') << 16 |
		    ('T' - '\e') <<  8 | ('H' - '\e'),
    ID_MANNO	  = ('A' - '\e') << 24 | ('N' - '\e') << 16 |
		    ('N' - '\e') <<  8 | ('O' - '\e'),
    ID_MINS1	  = ('I' - '\e') << 24 | ('N' - '\e') << 16 |
		    ('S' - '\e') <<  8 | ('1' - '\e'),
    ID_MTRAK	  = ('T' - '\e') << 24 | ('R' - '\e') << 16 |
		    ('A' - '\e') <<  8 | ('K' - '\e');

type
    SScoreHeader_t = struct {
	uint ssh_tempo; 	/* tempo in 128ths quarter note/minute */
	ushort ssh_volume;	/* overall playback volume, 0 - 127 */
	ushort ssh_ctTrack;	/* number of TRAKs in the score */
    },

    InstrumentType_t = enum {
	it_name,		/* just use name; ignore data1, data2 */
	it_midi 		/* midi - data1 is channel; data2 is preset */
    },

    RefInstrument_t = struct {
	ushort ri_register;	/* set this instrument register number */
	InstrumentType_t ri_type;
	ushort ri_data1, ri_data2;
	[1] char ri_name;	/* length of name is determined by chunksize */
    },

    SEvent_t = struct {
	ushort se_id;		/* SEvent type code */
	ushort se_data; 	/* se_id - dependent data */
    };

ushort
    SID_FirstNote	= 0,
    SID_LastNote	= 127,

    SID_Rest		= 128,	/* a rest (same data format as a note) */
    SID_Instrument	= 129,	/* set instrument number for this track */
    SID_TimeSig 	= 130,	/* set time signature for this track */
    SID_KeySig		= 131,	/* set key signature for this track */
    SID_Dynamic 	= 132,	/* set volume for this track */
    SID_MIDI_Chnl	= 133,	/* set MIDI channel number (sequencers) */
    SID_MIDI_Preset	= 134,	/* set MIDI preset number (sequencers) */

    SID_Mark		= 255;	/* not used - can be an end marker in RAM */

/* the following masks pull out fields of the se_data for note or rest */

ushort
    NOTE_CHORD		= 0x80,
    NOTE_TIEOUT 	= 0x40,
    NOTE_TUPLE		= 0x30,
	NOTE_NO_TUPLE	= 0x00,
	NOTE_TRIPLET	= 0x10,
	NOTE_QUINTUPLET = 0x20,
	NOTE_SEPTUPLET	= 0x30,
    NOTE_DOT		= 0x80,
    NOTE_DIVISION	= 0x07,
	NOTE_D1 	= 0x00, /* whole note */
	NOTE_D2 	= 0x01, /* half note */
	NOTE_D4 	= 0x02, /* quarter note */
	NOTE_D8 	= 0x03, /* eighth note */
	NOTE_D16	= 0x04, /* sixteenth note */
	NOTE_D32	= 0x05, /* thirty-second note */
	NOTE_D64	= 0x06, /* sixty-fourth note */
	NOTE_D128	= 0x07; /* 1/128 note */

/* the following masks pull out fields for a time signature SEvent */

ushort
    TIME_SIG_NUMERATOR	= 0xf8, /* actual numerator is value + 1 */
    TIME_SIG_DENOMINATOR= 0x07; /* as in NOTE_DIVISION */

/* default time signature is 4/4 time (0x1a) */

/* key signature values:
   data    key	  notation
   00	   C maj
   01	   G	    #
   02	   D	    ##
   03	   A	    ###
   04	   E	    ####
   05	   B	    #####
   06	   F#	    ######
   07	   C#	    #######
   08	   F	    b
   09	   Bb	    bb
   10	   Eb	    bbb
   11	   Ab	    bbbb
   12	   Db	    bbbbb
   13	   Gb	    bbbbbb
   14	   Cb	    bbbbbbb

default is C major */

/* dynamic mark. Data is MIDI key velocity number 0 - 127. This is scaled by
   the overall score volume from SHDR. Default is 127 (full volume) */
