#drinc:graphics/gfx.g
#drinc:graphics/rastport.g
#drinc:libraries/dos.g

#graphics.g
#iff.g
#iffILBM.g
#globals.g
#funcs.g

/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * iffWrite.d - code for writing IFF files (ILBM specifically).
 */

uint MAX_LEN = 128;

Handle_t OutputFd;
[IFF_BUFFER_SIZE] byte Buffer;
uint BufferPos, ByteCount, SavedDumpLength;
[MAX_LEN] byte Dump;
bool Counting, HadError;

proc flushBuffer()void:

    if not HadError and BufferPos ~= 0 then
	if Write(OutputFd, &Buffer[0], BufferPos) ~= BufferPos then
	    HadError := true;
	fi;
	BufferPos := 0;
    fi;
corp;

proc putByte(byte b)void:

    if Counting then
	ByteCount := ByteCount + 1;
    else
	if not HadError then
	    if BufferPos = IFF_BUFFER_SIZE then
		flushBuffer();
	    fi;
	    Buffer[BufferPos] := b;
	    BufferPos := BufferPos + 1;
	fi;
    fi;
corp;

proc putStuff(register arbptr p; register uint len)void:
    register *byte bp @ p;

    while len ~= 0 do
	putByte(bp*);
	bp := bp + 1;
	len := len - 1;
    od;
corp;

proc putDump(uint len)void:

    if len ~= 0 then
	putByte(len - 1);
	putStuff(&Dump[0], len);
    fi;
corp;

proc putRun(byte b; int len)void:

    if SavedDumpLength ~= 0 then
	putDump(SavedDumpLength);
	SavedDumpLength := 0;
    fi;
    putByte(- (len - 1));
    putByte(b);
corp;

proc putRow(register *byte p)void:
    register uint len, i;
    register byte lastByte, thisByte;
    bool inDump;

    SavedDumpLength := 0;
    inDump := true;
    len := 0;
    lastByte := ~ p*;
    for i from GraphicsWidth / 8 - 1 downto 0 do
	thisByte := p*;
	p := p + 1;
	if inDump then
	    if thisByte = lastByte and len ~= 0 then
		SavedDumpLength := len - 1;
		len := 2;
		inDump := false;
	    else
		Dump[len] := thisByte;
		len := len + 1;
		if len = MAX_LEN then
		    putDump(len);
		    len := 0;
		fi;
	    fi;
	else
	    if thisByte = lastByte then
		len := len + 1;
		if len = MAX_LEN then
		    putRun(thisByte, len);
		    inDump := true;
		    len := 0;
		fi;
	    else
		if len = 2 then
		    len := SavedDumpLength;
		    SavedDumpLength := 0;
		    Dump[len] := lastByte;
		    Dump[len + 1] := lastByte;
		    Dump[len + 2] := thisByte;
		    len := len + 3;
		else
		    putRun(lastByte, len);
		    Dump[0] := thisByte;
		    len := 1;
		fi;
		inDump := true;
	    fi;
	fi;
	lastByte := thisByte;
    od;
    if len ~= 0 then
	if inDump then
	    putDump(len);
	else
	    putRun(lastByte, len);
	fi;
    fi;
corp;

proc iffDumpILBM(*char fileName; *RastPort_t rp;
	register *uint colourTable; bool stripHighPlane)void:
    [4] char MESS1 = ('F', 'O', 'R', 'M');
    [8] char MESS2 = ('I', 'L', 'B', 'M', 'B', 'M', 'H', 'D');
    [4] char MESS3 = ('C', 'M', 'A', 'P');
    [4] char MESS4 = ('B', 'O', 'D', 'Y');
    register *BitMap_t bm;
    BitMap_t myBitMap;
    RastPort_t myRastPort;
    BitMapHeader_t bmh;
    ColorRegister_t cr;
    ulong size, count;
    register ulong offset;
    register uint i, j, k;
    uint depth, cmSize;
    byte b;
    bool usedTempRp;

    OutputFd := Open(fileName, MODE_NEWFILE);
    if OutputFd = 0 then
	putString("::Can't open snapshot file \"");
	putString(fileName);
	putString("\" - graphics snapshot not made.\n");
    else
	if stripHighPlane or GXOffset ~= 0 or GYOffset ~= 0 then
	    usedTempRp := true;
	    depth := rp*.rp_BitMap*.bm_Depth;
	    if stripHighPlane and depth > 0 then
		depth := depth - 1;
	    fi;
	    bm := &myBitMap;
	    if not allocBitMap(bm, depth, GraphicsWidth, GraphicsHeight,
			       "snapshot bitmap")
	    then
		Close(OutputFd);
		return;
	    fi;
	    InitRastPort(&myRastPort);
	    myRastPort.rp_BitMap := bm;
	    ignore ClipBlit(rp, GXOffset, GYOffset, &myRastPort, 0, 0,
			    GraphicsWidth, GraphicsHeight, 0xc0);
	else
	    usedTempRp := false;
	    bm := rp*.rp_BitMap;
	    depth := GRAPHICS_DEPTH;
	fi;
	Counting := true;
	ByteCount := 0;
	offset := 0;
	for i from GraphicsHeight - 1 downto 0 do
	    for j from 0 upto depth - 1 do
		putRow(pretend(bm*.bm_Planes[j] + offset, *byte));
	    od;
	    offset := offset + bm*.bm_BytesPerRow;
	od;

	BufferPos := 0;
	Counting := false;
	HadError := false;
	size := ByteCount;
	if size & 1 ~= 0 then
	    size := size + 1;
	fi;
	if colourTable = nil then
	    cmSize := 0;
	else
	    cmSize := 8 + sizeof(ColorRegister_t) * ColourCount;
	fi;
	putStuff(&MESS1[0], 4);
	count := 20 + size + sizeof(BitMapHeader_t) + cmSize;
	putStuff(&count, 4);
	putStuff(&MESS2[0], 8);
	count := sizeof(BitMapHeader_t);
	putStuff(&count, 4);
	bmh := BitMapHeader_t(
	    0, 0, 0, 0, 0,
	    bmsk_none, bcmp_byteRun1, 0,
	    0, 10, 11, 0, 0
	);
	i := GraphicsWidth;
	j := GraphicsHeight;
	bmh.bmh_w := i;
	bmh.bmh_h := j;
	bmh.bmh_nPlanes := bm*.bm_Depth;
	bmh.bmh_pageWidth := i;
	bmh.bmh_pageHeight := j;
	while i >= 256 or j >= 256 do
	    for k from 2 upto 20 do
		while i % k = 0 and j % k = 0 do
		    i := i / k;
		    j := j / k;
		od;
	    od;
	od;
	while i >= 256 or j >= 256 do
	    i := i / 2;
	    j := j / 2;
	od;
	bmh.bmh_xAspect := i;
	bmh.bmh_yAspect := j;
	putStuff(&bmh, sizeof(BitMapHeader_t));
	if colourTable ~= nil then
	    putStuff(&MESS3[0], 4);
	    count := ColourCount * sizeof(ColorRegister_t);
	    putStuff(&count, 4);
	    for i from ColourCount - 1 downto 0 do
		j := colourTable*;
		colourTable := colourTable + sizeof(uint);
		cr.cr_blue := j & 0xf << 4;
		j := j >> 4;
		cr.cr_green := j & 0xf << 4;
		j := j >> 4;
		cr.cr_red := j & 0xf << 4;
		putStuff(&cr, sizeof(ColorRegister_t));
	    od;
	fi;
	putStuff(&MESS4[0], 4);
	count := size;
	putStuff(&count, 4);
	offset := 0;
	for i from GraphicsHeight - 1 downto 0 do
	    for j from 0 upto depth - 1 do
		putRow(pretend(bm*.bm_Planes[j] + offset, *byte));
	    od;
	    offset := offset + bm*.bm_BytesPerRow;
	od;
	if ByteCount & 1 ~= 0 then
	    putByte(0);
	fi;
	flushBuffer();
	if HadError then
	    putString("::Error writing to snapshot file \"");
	else
	    putString("::Graphics snapshot made to file \"");
	fi;
	putString(fileName);
	putString("\".\n");
	Close(OutputFd);
	if usedTempRp then
	    freeBitMap(bm, GraphicsWidth, GraphicsHeight);
	fi;
    fi;
corp;
