/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * sound.g - declarations, etc. for sound and music playing.
 */

uint
    MAX_TRACKS = 4,
    MAX_INSTRUMENTS = 16;

type
    Sound_t = struct {
	*short sn_data;
	ulong sn_bufferLength, sn_sampleLength;
	Voice8Header_t sn_v8h;
	uint sn_attackLength, sn_releaseLength;
	*EGPoint_t sn_attack, sn_release;
	bool sn_hadBODY;
    },

    Instrument_t = struct {
	*char ins_name;
	ulong ins_nameLen;
	*Sound_t ins_sound;
    },

    Track_t = struct {
	*byte tr_events;
	ulong tr_length;
	uint tr_instrument;
    },

    Music_t = struct {
	SScoreHeader_t mu_ssh;
	[MAX_INSTRUMENTS] Instrument_t mu_instruments;
	uint mu_instrumentCount;
	[MAX_TRACKS] Track_t mu_tracks;
	uint mu_trackCount;
    };
