/*
 * Amiga MUD
 *
 * Copyright (c) 1997 by Chris Gray
 */

/*
 * text.g - definitions for text stuff.
 */

uint
    TEXT_DEPTH = 2,

    STD_TEXT_PEN = 1,
    CST_TEXT_PEN = 3,
    DARK_PEN = 2,
    LIGHT_PEN = 1,
    ERASE_PEN = 0,

    TITLE_BAR = 11,
    OLD_SCROLL_WIDTH = 16,
    NEW_SCROLL_WIDTH = 10,
    WB_SCROLL_WIDTH = 16,
    SIZE_HEIGHT = 10,

    CHAR_HEIGHT = 8,			/* height of characters */
    CHAR_BASELINE = 6,			/* position of baseline */
    CHAR_WIDTH = 8;			/* width of characters */

uint
    MAX_TEXT_COLUMNS = 200;

uint
    EDIT_HELP_WIDTH = 73,		/* See edit.d/ed_showHelp */
    EDIT_HELP_HEIGHT = 23;

uint
    KEY_SHIFT = 0x4000,
    KEY_UP = 0x8000,
    KEY_DOWN = 0x8001,
    KEY_RIGHT = 0x8002,
    KEY_LEFT = 0x8003,
    KEY_FUNC = 0x8010,

    KEY_HELP  = 0x0020,
    KEY_KP_UL = 0x0001,
    KEY_KP_U  = 0x0002,
    KEY_KP_UR = 0x0003,
    KEY_KP_L  = 0x0004,
    KEY_KP_C  = 0x0005,
    KEY_KP_R  = 0x0006,
    KEY_KP_DL = 0x0007,
    KEY_KP_D  = 0x0008,
    KEY_KP_DR = 0x0009,
    KEY_KP_PLUS = 0x000a,
    KEY_KP_MINUS = 0x000b;

type
    HistoryType_t = enum {
	ht_full,			/* everything goes into the history */
	ht_new, 			/* all except strict last duplicate */
	ht_minimal			/* only non-history is added */
    },

    ScrollType_t = enum {
	st_input,			/* scroll to bottom on input */
	st_output,			/* on output */
	st_either,			/* on either */
	st_neither			/* on neither */
    };

extern
    /* Intuition.d */

    doPictureMenu()void,
    doEditWinState(bool enableIt)void,
    doShowPicture()void,
    doHidePicture()void,

    /* text.d */

    tx_setScrollStuff(bool amEditing)void,
    tx_refresh()void,
    tx_drawBorders(uint height)void,
    tx_resetVars()void,
    tx_setHistoryType(HistoryType_t historyType)void,
    tx_setScrollType(ScrollType_t scrollType)void,
    tx_setHistorySizes(ulong outputHistorySize, inputHistorySize)void,
    tx_init0()void,
    tx_reInit()void,
    tx_init1()bool,
    tx_term()void,
    tx_toggleCursor()void,
    tx_setup()void,
    tx_refreshInputLine()void,
    tx_inputLine(*char buffer; uint len)void,
    tx_cookChar(char ch; bool wantInput)void,
    tx_specialKey(uint ch)void,
    tx_doAnyScroll(int dx, dy; uint xmin, ymin, xmax, ymax)void,
    tx_scroll()void,
    tx_scrollLines(bool scrollUp, scrollWindow)void,
    tx_redraw(bool full)void,
    tx_graphicsOn()void,
    tx_graphicsOff()void,
    ed_scroll()void,
    logMode(bool inputOnly)void,
    buildPath(*char buffer, dir, name)void,
    logOn(*char dir, fileName)bool,
    logOff()void,
    tx_snapshot(*char dir, fileName)void,

    /* edit.d */

    ed_refresh()void,
    ed_redraw()void,
    ed_init()void,
    ed_hide()void,
    ed_show()void,
    ed_cookChar(char ch)void,
    ed_specialKey(uint ch)void,
    ed_scrollLines(bool scrollUp, scrollWindow)void,
    ed_scroll2(uint vertPot)void;
